/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.caffeine;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReferenceListener;
import com.atlassian.cache.impl.CachedReferenceListenerSupport;
import com.atlassian.cache.impl.ReferenceKey;
import com.atlassian.confluence.cache.ConfluenceCachedReference;
import com.atlassian.confluence.impl.cache.caffeine.CaffeineManagedCacheTemplate;
import com.github.benmanes.caffeine.cache.Cache;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CaffeineCachedReferenceImpl<V>
extends CaffeineManagedCacheTemplate
implements ConfluenceCachedReference<V> {
    private final Supplier<V> valueSupplier;
    private final Cache<ReferenceKey, V> caffeine;
    private final CachedReferenceListenerSupport<V> listenerSupport;

    CaffeineCachedReferenceImpl(String name, CacheSettings settings, Supplier<V> valueSupplier, Cache<ReferenceKey, V> caffeine, CachedReferenceListenerSupport<V> listenerSupport) {
        super(name, settings, caffeine);
        this.valueSupplier = valueSupplier;
        this.caffeine = caffeine;
        this.listenerSupport = listenerSupport;
    }

    public @NonNull V get() {
        return (V)Objects.requireNonNull(this.caffeine.get((Object)ReferenceKey.KEY, k -> this.valueSupplier.get()));
    }

    public void reset() {
        this.caffeine.invalidate((Object)ReferenceKey.KEY);
    }

    public Optional<V> getIfPresent() {
        return Optional.ofNullable(this.caffeine.getIfPresent((Object)ReferenceKey.KEY));
    }

    public void addListener(CachedReferenceListener<V> listener, boolean includeValues) {
        this.listenerSupport.add(listener, includeValues);
    }

    public void removeListener(CachedReferenceListener<V> listener) {
        this.listenerSupport.remove(listener);
    }

    @Override
    public Integer currentMaxEntries() {
        return 1;
    }

    @Override
    public boolean updateMaxEntries(int newValue) {
        return false;
    }
}

