/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.cache.caffeine;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.confluence.cache.ManagedCacheTemplate;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CaffeineManagedCacheTemplate
extends ManagedCacheTemplate {
    private static final Logger log = LoggerFactory.getLogger(CaffeineManagedCacheTemplate.class);
    private final Cache<?, ?> caffeine;

    CaffeineManagedCacheTemplate(String name, CacheSettings settings, Cache<?, ?> caffeine) {
        super(name, settings);
        this.caffeine = caffeine;
    }

    public void clear() {
        this.caffeine.invalidateAll();
    }

    public @Nullable Long currentExpireAfterAccessMillis() {
        return this.caffeine.policy().expireAfterAccess().map(Policy.FixedExpiration::getExpiresAfter).map(Duration::toMillis).orElse(null);
    }

    public @Nullable Long currentExpireAfterWriteMillis() {
        return this.caffeine.policy().expireAfterWrite().map(Policy.FixedExpiration::getExpiresAfter).map(Duration::toMillis).orElse(null);
    }

    public boolean updateExpireAfterAccess(long expireAfter, TimeUnit timeUnit) {
        return CaffeineManagedCacheTemplate.setExpiryPolicy(this.caffeine.policy().expireAfterAccess(), expireAfter, timeUnit);
    }

    public boolean updateExpireAfterWrite(long expireAfter, TimeUnit timeUnit) {
        return CaffeineManagedCacheTemplate.setExpiryPolicy(this.caffeine.policy().expireAfterWrite(), expireAfter, timeUnit);
    }

    private static <K, V> boolean setExpiryPolicy(Optional<Policy.FixedExpiration<K, V>> expiration, long expireAfter, TimeUnit timeUnit) {
        if (expiration.isPresent()) {
            expiration.get().setExpiresAfter(expireAfter, timeUnit);
            return true;
        }
        return false;
    }

    public @Nullable Integer currentMaxEntries() {
        return this.caffeine.policy().eviction().map(policy -> (int)policy.getMaximum()).orElse(null);
    }

    public boolean updateMaxEntries(int newValue) {
        Optional policy = this.caffeine.policy().eviction();
        if (policy.isPresent()) {
            Policy.Eviction eviction = (Policy.Eviction)policy.get();
            eviction.setMaximum((long)newValue);
            log.debug("Updated max size of cache [{}] to {}", (Object)this.getName(), (Object)newValue);
            return true;
        }
        log.debug("Cache [{}] has no eviction policy - cannot change max size", (Object)this.getName());
        return false;
    }

    public SortedMap<CacheStatisticsKey, Supplier<Long>> getStatistics() {
        CacheStats stats = this.caffeine.stats();
        return new TreeMap<CacheStatisticsKey, Supplier<Long>>(Map.of(CacheStatisticsKey.SIZE, () -> this.caffeine.estimatedSize(), CacheStatisticsKey.HIT_COUNT, () -> ((CacheStats)stats).hitCount(), CacheStatisticsKey.MISS_COUNT, () -> ((CacheStats)stats).missCount(), CacheStatisticsKey.LOAD_COUNT, () -> ((CacheStats)stats).loadCount(), CacheStatisticsKey.EVICTION_COUNT, () -> ((CacheStats)stats).evictionCount()));
    }
}

