/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.data;

import com.atlassian.html.encode.JavascriptEncoder;
import com.atlassian.html.encode.JavascriptEncodingWriter;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.webresource.util.CspUtil;
import com.atlassian.security.csp.api.internal.NonceService;
import com.atlassian.webresource.api.data.PluginDataResource;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTagWriter {
    private static final Logger log = LoggerFactory.getLogger(DataTagWriter.class);
    private static final String SCRIPT_TAG_WITH_NONCE_NAME = "<script nonce=\"%s\">\n";
    private static final String SCRIPT_TAG = "<script>\n";
    private static final String PRE = "window.WRM=window.WRM||{};window.WRM._unparsedData=window.WRM._unparsedData||{};window.WRM._unparsedErrors=window.WRM._unparsedErrors||{};\n";
    private static final String POST = "if(window.WRM._dataArrived)window.WRM._dataArrived();</script>\n";

    public void write(Writer writer, Iterable<PluginDataResource> data, NonceService nonceService) throws IOException {
        String nonce = null;
        if (nonceService != null) {
            nonce = nonceService.getNonce();
        } else if (Boolean.getBoolean("csp.enable.nonce")) {
            log.warn("NonceService is null. Proceeding without nonce.");
        }
        boolean scriptTagWritten = false;
        for (PluginDataResource datum : data) {
            if (!scriptTagWritten) {
                if (CspUtil.isNonceEnabled("js", nonce)) {
                    writer.write(String.format(SCRIPT_TAG_WITH_NONCE_NAME, nonce));
                } else {
                    writer.write(SCRIPT_TAG);
                }
                writer.write(PRE);
                scriptTagWritten = true;
            }
            this.write(writer, datum);
        }
        if (scriptTagWritten) {
            writer.write(POST);
        }
    }

    private void write(Writer writer, PluginDataResource data) throws IOException {
        try {
            Optional result = data.getData();
            if (result.isPresent()) {
                writer.write("WRM._unparsedData[\"");
                JavascriptEncoder.escape((Writer)writer, (String)data.getKey());
                writer.write("\"]=\"");
                ((Jsonable)result.get()).write((Writer)new JavascriptEncodingWriter(writer));
                writer.write("\";\n");
            } else {
                writer.write("WRM._unparsedErrors[\"");
                JavascriptEncoder.escape((Writer)writer, (String)data.getKey());
                writer.write("\"]=\"\";\n");
            }
        }
        catch (IOException ex) {
            log.error("IOException encountered rendering data resource '{}'", (Object)new String[]{data.getKey()}, (Object)ex);
        }
        catch (RuntimeException ex) {
            log.error("Exception encountered rendering data resource '{}'", (Object)new String[]{data.getKey()}, (Object)ex);
        }
    }
}

