/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.filter.rewrite;

import com.atlassian.plugin.servlet.ResourceDownloadUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tuckey.web.filters.urlrewrite.extend.RewriteMatch;
import org.tuckey.web.filters.urlrewrite.extend.RewriteRule;

public class ResourceDownloadRewriteRule
extends RewriteRule {
    private static final Pattern NON_WEB_INF_RESOURCES_URI_PATTERN = Pattern.compile("^/s/(.*)/_/((?i)(?!WEB-INF).*)");

    public RewriteMatch matches(HttpServletRequest request, HttpServletResponse response) {
        String normalisedRequestUriPath;
        try {
            normalisedRequestUriPath = this.getNormalisedPathFrom(request);
        }
        catch (URISyntaxException invalidUriInRequest) {
            return null;
        }
        final Matcher nonWebInfResourcesPatternMatcher = NON_WEB_INF_RESOURCES_URI_PATTERN.matcher(normalisedRequestUriPath);
        if (!nonWebInfResourcesPatternMatcher.matches()) {
            return null;
        }
        final String rewrittenUriPath = "/" + nonWebInfResourcesPatternMatcher.group(2);
        final String rewrittenUrl = request.getContextPath() + rewrittenUriPath;
        return new RewriteMatch(this){

            public String getMatchingUrl() {
                return rewrittenUrl;
            }

            public boolean execute(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                ResourceDownloadUtils.addPublicCachingHeaders((HttpServletRequest)request, (HttpServletResponse)response);
                request.setAttribute("_statichash", (Object)nonWebInfResourcesPatternMatcher.group(1));
                request.getRequestDispatcher(rewrittenUriPath).forward((ServletRequest)request, (ServletResponse)response);
                return true;
            }
        };
    }

    private String getNormalisedPathFrom(HttpServletRequest request) throws URISyntaxException {
        return new URI(this.stripContextFrom(request)).normalize().toString();
    }

    private String stripContextFrom(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }
}

