/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl;

import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.webresource.api.transformer.TransformerParameters;
import com.atlassian.webresource.api.url.UrlBuilder;
import java.util.List;
import java.util.Set;

public class CachedTransformers {
    private final List<WebResourceTransformation> transformations;

    public CachedTransformers(List<WebResourceTransformation> transformations) {
        this.transformations = transformations;
    }

    public void addToUrlSafely(UrlBuilder urlBuilder, UrlBuildingStrategy urlBuildingStrategy, String type, TransformerCache transformerCache, TransformerParameters transformerParameters, String webResourceKey) {
        for (WebResourceTransformation transformation : this.transformations) {
            if (!transformation.matches(type)) continue;
            try {
                transformation.addTransformParameters(transformerCache, transformerParameters, urlBuilder, urlBuildingStrategy);
            }
            catch (RuntimeException e) {
                Support.LOGGER.warn("error thrown in transformer during url generation for " + webResourceKey, (Throwable)e);
            }
        }
    }

    public List<WebResourceTransformation> getTransformations() {
        return this.transformations;
    }

    public boolean addAllUsedQueryParameters(Set<String> paramKeys, String type, TransformerCache transformerCache) {
        for (WebResourceTransformation transformation : this.transformations) {
            if (!transformation.matches(type) || transformation.addAllUsedQueryParameters(paramKeys, transformerCache)) continue;
            return false;
        }
        return true;
    }
}

