/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.util;

public class CspUtil {
    public static final String JS = "js";
    public static final String CSS = "css";
    public static final String PREFETCH = "prefetch";

    private CspUtil() {
    }

    public static boolean isJsNonceEnabled() {
        return Boolean.getBoolean("csp.enable.nonce.js");
    }

    public static boolean isCssNonceEnabled() {
        return Boolean.getBoolean("csp.enable.nonce.css");
    }

    public static boolean isPrefetchNonceEnabled() {
        return Boolean.getBoolean("csp.enable.nonce.prefetch");
    }

    public static boolean isNonceEnabled(String type, String nonce) {
        if (nonce == null || nonce.isEmpty()) {
            return false;
        }
        switch (type) {
            case "js": {
                return CspUtil.isJsNonceEnabled();
            }
            case "css": {
                return CspUtil.isCssNonceEnabled();
            }
            case "prefetch": {
                return CspUtil.isPrefetchNonceEnabled();
            }
        }
        return false;
    }
}

