/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.analytics;

import com.atlassian.confluence.plugins.restapi.analytics.RestEndpointAnalyticsEvent;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Priority;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

@Priority(value=5200)
@Provider
class AnalyticEventSenderResourceFilter
implements ContainerResponseFilter {
    private final EventPublisher eventPublisher;
    private final ResourceInfo resourceInfo;

    AnalyticEventSenderResourceFilter(EventPublisher eventPublisher, ResourceInfo resourceInfo) {
        this.eventPublisher = eventPublisher;
        this.resourceInfo = resourceInfo;
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        String httpMethod = containerRequestContext.getMethod();
        Class resourceClass = this.resourceInfo.getResourceClass();
        Method method = this.resourceInfo.getResourceMethod();
        if (resourceClass.isAnnotationPresent(SendsAnalytics.class)) {
            String methodPath;
            Object path;
            if (resourceClass.isAnnotationPresent(Path.class)) {
                Path classAnnotation = resourceClass.getAnnotation(Path.class);
                path = AnalyticEventSenderResourceFilter.stripSlashes(classAnnotation.value());
            } else {
                path = AnalyticEventSenderResourceFilter.stripSlashes(containerRequestContext.getUriInfo().getPath());
            }
            if (method.isAnnotationPresent(Path.class) && !(methodPath = AnalyticEventSenderResourceFilter.stripSlashes(method.getAnnotation(Path.class).value())).isEmpty()) {
                path = (String)path + "/" + methodPath;
            }
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            this.eventPublisher.publish((Object)new RestEndpointAnalyticsEvent(httpMethod, (String)path));
        }
    }

    private static String stripSlashes(String path) {
        return StringUtils.stripEnd((String)StringUtils.stripStart((String)path, (String)"/"), (String)"/");
    }
}

