/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.annotations;

import jakarta.ws.rs.container.ResourceInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ResourceAnnotationUtil {
    public static boolean isAnnotated(@NonNull AnnotatedElement annotatedElement, @NonNull String simpleAnnotationName) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = annotatedElement.getDeclaredAnnotations()) {
            if (!simpleAnnotationName.equals(annotation.annotationType().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(ResourceInfo resourceInfo, String annotation) {
        return ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceMethod(), annotation) || ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceClass(), annotation) || ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceClass().getPackage(), annotation);
    }
}

