/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.experimental.resources;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.content.ContentVersionService;
import com.atlassian.confluence.api.service.content.VersionRestoreParameters;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.serialization.jackson2.RestData;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;

@ExperimentalApi
@AnonymousSiteAccess
@LimitRequestSize(value=0x500000L)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/version")
public class ContentVersionResource {
    private final ContentVersionService contentVersionService;

    @Inject
    public ContentVersionResource(@ComponentImport ContentVersionService contentVersionService) {
        this.contentVersionService = contentVersionService;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Version> getContentHistory(@PathParam(value="id") ContentId contentId, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @QueryParam(value="expand") @DefaultValue(value="") String expand, @Context UriInfo uriInfo) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        PageResponse versions = this.contentVersionService.find(expansions).withId(contentId).fetchMany((PageRequest)pageRequest);
        return RestList.createRestList((PageRequest)pageRequest.copyWithLimits(versions), (PageResponse)versions);
    }

    @GET
    @Path(value="{versionNumber}")
    @ScopesAllowed(requiredScope={"READ"})
    public Version getContentVersion(@PathParam(value="id") ContentId contentId, @PathParam(value="versionNumber") int versionNumber, @QueryParam(value="expand") @DefaultValue(value="content") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return (Version)this.contentVersionService.find(expansions).withIdAndVersion(contentId, versionNumber).fetchOrNull();
    }

    @DELETE
    @Path(value="/{versionId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public void deleteContentHistory(@PathParam(value="id") ContentId contentId, @PathParam(value="versionId") int versionNumber) {
        this.contentVersionService.delete(contentId, versionNumber);
    }

    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public Version restoreContentHistory(@PathParam(value="id") ContentId contentId, RestData restData, @QueryParam(value="expand") @DefaultValue(value="content") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        if (!restData.getOperationKey().equals((Object)OperationKey.RESTORE)) {
            throw new BadRequestException(String.format("'%s' is not a supported operation on a Content Version. Supported operations are: 'RESTORE'", restData.getOperationKey()));
        }
        return this.contentVersionService.restore(contentId, VersionRestoreParameters.fromMap((Map)restData.getParams()), expansions);
    }
}

