/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.experimental.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.user.UserKey;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;

@AnonymousSiteAccess
@LimitRequestSize
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/restriction")
public class ExperimentalContentRestrictionsResource {
    private static final String DEFAULT_FOR_OPERATION_EXPANSIONS = "restrictions.user,restrictions.group";
    private final ContentRestrictionService service;

    @Inject
    public ExperimentalContentRestrictionsResource(@ComponentImport ContentRestrictionService service) {
        this.service = service;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<ContentRestriction> getRestrictions(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="restrictions.user,restrictions.group") String expand, @Context UriInfo uriInfo, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit) {
        Expansion[] expansions = ExpansionsParser.parseExperimental((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return this.service.getRestrictions(contentId, (PageRequest)pageRequest, expansions);
    }

    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    public PageResponse<ContentRestriction> updateRestrictions(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="restrictions.user,restrictions.group") String expand, PageResponse<ContentRestriction> contentRestrictions) {
        Expansion[] expansions = ExpansionsParser.parseExperimental((String)expand);
        return this.service.updateRestrictions(contentId, (Collection)contentRestrictions.getResults(), expansions);
    }

    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public PageResponse<ContentRestriction> addRestrictions(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="restrictions.user,restrictions.group") String expand, PageResponse<ContentRestriction> contentRestrictions) {
        Expansion[] expansions = ExpansionsParser.parseExperimental((String)expand);
        return this.service.addRestrictions(contentId, (Collection)contentRestrictions.getResults(), expansions);
    }

    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    public PageResponse<ContentRestriction> deleteRestrictions(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="restrictions.user,restrictions.group") String expand) {
        Expansion[] expansions = ExpansionsParser.parseExperimental((String)expand);
        return this.service.deleteAllDirectRestrictions(contentId, expansions);
    }

    @GET
    @Path(value="/byOperation/{operationKey}/user")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getIndividualUserRestrictionStatus(@PathParam(value="id") ContentId contentId, @PathParam(value="operationKey") OperationKey operationKey, @QueryParam(value="key") UserKey userKey, @QueryParam(value="userName") String userName) {
        User user = this.userFromKeyOrName(userKey, userName);
        if (this.service.hasDirectRestrictionForSubject(contentId, operationKey, (Subject)user)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/byOperation/{operationKey}/group/{groupName}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getIndividualGroupRestrictionStatus(@PathParam(value="id") ContentId contentId, @PathParam(value="operationKey") OperationKey operationKey, @PathParam(value="groupName") Group group) {
        if (this.service.hasDirectRestrictionForSubject(contentId, operationKey, (Subject)group)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="/byOperation/{operationKey}/user")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteIndividualUserRestriction(@PathParam(value="id") ContentId contentId, @PathParam(value="operationKey") OperationKey operationKey, @QueryParam(value="key") UserKey userKey, @QueryParam(value="userName") String userName) {
        User user = this.userFromKeyOrName(userKey, userName);
        this.service.deleteDirectRestrictionForSubject(contentId, operationKey, (Subject)user);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/byOperation/{operationKey}/group/{groupName}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response deleteIndividualGroupRestriction(@PathParam(value="id") ContentId contentId, @PathParam(value="operationKey") OperationKey operationKey, @PathParam(value="groupName") Group group) {
        this.service.deleteDirectRestrictionForSubject(contentId, operationKey, (Subject)group);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/byOperation/{operationKey}/user")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response addIndividualUserRestriction(@PathParam(value="id") ContentId contentId, @PathParam(value="operationKey") OperationKey operationKey, @QueryParam(value="key") UserKey userKey, @QueryParam(value="userName") String userName) {
        User user = this.userFromKeyOrName(userKey, userName);
        this.service.addDirectRestrictionForSubject(contentId, operationKey, (Subject)user);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/byOperation/{operationKey}/group/{groupName}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response addIndividualGroupRestriction(@PathParam(value="id") ContentId contentId, @PathParam(value="operationKey") OperationKey operationKey, @PathParam(value="groupName") Group group) {
        this.service.addDirectRestrictionForSubject(contentId, operationKey, (Subject)group);
        return Response.ok().build();
    }

    private User userFromKeyOrName(UserKey userKey, String userName) {
        if (userKey != null) {
            return User.fromUserkey((UserKey)userKey);
        }
        if (userName != null) {
            return User.fromUsername((String)userName);
        }
        throw new BadRequestException("either userName or userKey should not be <null>");
    }
}

