/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.experimental.resources;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@ExperimentalApi
@AnonymousSiteAccess
@LimitRequestSize(value=0x500000L)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/group")
public class ExperimentalGroupResource {
    private final GroupService groupService;
    private final PersonService personService;

    @Inject
    public ExperimentalGroupResource(@ComponentImport GroupService groupService, @ComponentImport PersonService personService) {
        this.groupService = groupService;
        this.personService = personService;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Group> getGroups(@QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return RestList.newRestList((PageResponse)this.groupService.find(expansions).fetchMany((PageRequest)pageRequest)).pageRequest((PageRequest)pageRequest).build();
    }

    @GET
    @Path(value="{groupName}")
    @ScopesAllowed(requiredScope={"READ"})
    public Group getGroup(@PathParam(value="groupName") String groupName, @QueryParam(value="expand") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return (Group)this.groupService.find(expansions).withName(groupName).fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No group with name : " + groupName)));
    }

    @GET
    @Path(value="{groupName}/member")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Person> getMembers(@PathParam(value="groupName") Group group, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        PageResponse results = this.personService.find(expansions).withMembershipOf(group).fetchMany((PageRequest)request);
        return RestList.newRestList((PageResponse)results).pageRequest((PageRequest)request).build();
    }
}

