/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.experimental.resources;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/user")
@LimitRequestSize(value=0x500000L)
public class ExperimentalUserResource {
    private final PersonService personService;
    private final GroupService groupService;

    @Inject
    public ExperimentalUserResource(@ComponentImport PersonService personService, @ComponentImport GroupService groupService) {
        this.personService = personService;
        this.groupService = groupService;
    }

    @ExperimentalApi
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Person getUser(@QueryParam(value="key") UserKey key, @QueryParam(value="username") String username, @QueryParam(value="expand") String expand) {
        if (key == null && Strings.isNullOrEmpty((String)username) || key != null && !Strings.isNullOrEmpty((String)username)) {
            throw new BadRequestException("Only one query param of key or username is required");
        }
        PersonService.PersonFinder personFinder = this.personService.find(ExpansionsParser.parse((String)expand));
        if (key != null) {
            personFinder.withUserKey(key);
        } else {
            personFinder.withUsername(username);
        }
        return (Person)personFinder.fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No user found with key : " + String.valueOf(key))));
    }

    @GET
    @Path(value="/current")
    @ScopesAllowed(requiredScope={"READ"})
    public Person getCurrent(@QueryParam(value="expand") String expand) {
        return this.personService.getCurrentUser(ExpansionsParser.parse((String)expand));
    }

    @GET
    @Path(value="/anonymous")
    @ScopesAllowed(requiredScope={"READ"})
    public Person getAnonymous() {
        return (Person)this.personService.find(new Expansion[0]).withUserKey(null).fetchOrNull();
    }

    @GET
    @Path(value="/memberof")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<Group> getGroups(@QueryParam(value="key") UserKey userKey, @QueryParam(value="username") String username, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest restPageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Person person = this.getUser(userKey, username, "");
        if (person instanceof User) {
            return RestList.newRestList((PageResponse)this.groupService.find(expansions).withMember((User)person).fetchMany((PageRequest)restPageRequest)).pageRequest((PageRequest)restPageRequest).build();
        }
        throw new NotFoundException(String.format("User cannot belong to a group : %s", person));
    }
}

