/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.experimental.resources;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.api.model.relations.RelationDescriptors;
import com.atlassian.confluence.api.model.relations.RelationInstance;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.api.service.relations.RelationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;

@ExperimentalApi
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/relation/{sourceType}/{sourceKey}/{relationName}/to{targetType}/{targetKey}")
public class RelationResource {
    private final RelationService relationService;
    private final PersonService personService;

    @Inject
    public RelationResource(@ComponentImport RelationService relationService, @ComponentImport PersonService personService) {
        Preconditions.checkNotNull((Object)relationService, (Object)"relationService must not be null");
        Preconditions.checkNotNull((Object)personService, (Object)"personFactory must not be null");
        this.relationService = relationService;
        this.personService = personService;
    }

    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Response isRelated(@PathParam(value="sourceType") String sourceType, @PathParam(value="sourceKey") String sourceKey, @PathParam(value="relationName") String relationName, @PathParam(value="targetType") String targetType, @PathParam(value="targetKey") String targetKey, @QueryParam(value="sourceStatus") ContentStatus sourceStatus, @QueryParam(value="targetStatus") ContentStatus targetStatus, @QueryParam(value="sourceVersion") Integer sourceVersion, @QueryParam(value="targetVersion") Integer targetVersion) throws NotFoundException, PermissionException {
        Class sourceClass = RelationResource.getRelatableClass(sourceType, "sourceType");
        Class targetClass = RelationResource.getRelatableClass(targetType, "targetType");
        if (!this.relationService.isRelated(this.buildRelatable(sourceClass, sourceKey, sourceStatus, sourceVersion, "source"), this.getRelationDescriptor(sourceClass, relationName, targetClass), this.buildRelatable(targetClass, targetKey, targetStatus, targetVersion, "target"))) {
            throw new NotFoundException("Relationship does not exist", SimpleValidationResult.VALID);
        }
        return Response.ok().entity(Collections.emptyMap()).build();
    }

    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response create(@PathParam(value="sourceType") String sourceType, @PathParam(value="sourceKey") String sourceKey, @PathParam(value="relationName") String relationName, @PathParam(value="targetType") String targetType, @PathParam(value="targetKey") String targetKey, @QueryParam(value="sourceStatus") ContentStatus sourceStatus, @QueryParam(value="targetStatus") ContentStatus targetStatus, @QueryParam(value="sourceVersion") Integer sourceVersion, @QueryParam(value="targetVersion") Integer targetVersion) throws NotFoundException, PermissionException {
        this.relationService.create(this.getRelationInstance(sourceType, sourceKey, sourceStatus, sourceVersion, relationName, targetType, targetKey, targetStatus, targetVersion));
        return Response.ok().entity(Collections.emptyMap()).build();
    }

    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response delete(@PathParam(value="sourceType") String sourceType, @PathParam(value="sourceKey") String sourceKey, @PathParam(value="relationName") String relationName, @PathParam(value="targetType") String targetType, @PathParam(value="targetKey") String targetKey, @QueryParam(value="sourceStatus") ContentStatus sourceStatus, @QueryParam(value="targetStatus") ContentStatus targetStatus, @QueryParam(value="sourceVersion") Integer sourceVersion, @QueryParam(value="targetVersion") Integer targetVersion) throws NotFoundException, PermissionException {
        this.relationService.delete(this.getRelationInstance(sourceType, sourceKey, sourceStatus, sourceVersion, relationName, targetType, targetKey, targetStatus, targetVersion));
        return Response.noContent().build();
    }

    private RelationInstance getRelationInstance(String sourceType, String sourceKey, ContentStatus sourceStatus, Integer sourceVersion, String relationName, String targetType, String targetKey, ContentStatus targetStatus, Integer targetVersion) {
        Class sourceClass = RelationResource.getRelatableClass(sourceType, "sourceType");
        Class targetClass = RelationResource.getRelatableClass(targetType, "targetType");
        return this.getRelationInstance(sourceClass, sourceKey, sourceStatus, sourceVersion, relationName, targetClass, targetKey, targetStatus, targetVersion);
    }

    private RelationInstance getRelationInstance(Class sourceType, String sourceKey, ContentStatus sourceStatus, Integer sourceVersion, String relationName, Class targetType, String targetKey, ContentStatus targetStatus, Integer targetVersion) {
        return RelationInstance.builder((Relatable)this.buildRelatable(sourceType, sourceKey, sourceStatus, sourceVersion, "source"), (RelationDescriptor)this.getRelationDescriptor(sourceType, relationName, targetType), (Relatable)this.buildRelatable(targetType, targetKey, targetStatus, targetVersion, "target")).build();
    }

    private RelationDescriptor getRelationDescriptor(Class sourceType, String relationName, Class targetType) {
        if (Strings.isNullOrEmpty((String)relationName)) {
            throw new BadRequestException("relationName parameter is required but was empty");
        }
        return RelationDescriptors.lookupBuiltinOrCreate((Class)sourceType, (String)relationName, (Class)targetType);
    }

    private Relatable buildRelatable(Class type, String key, ContentStatus status, Integer version, String side) {
        if (Strings.isNullOrEmpty((String)key)) {
            throw new BadRequestException(side + " key parameter is required but was empty");
        }
        if (type.equals(User.class)) {
            return this.buildLookupUser(key);
        }
        if (type.equals(Space.class)) {
            return Space.builder().key(key).build();
        }
        if (type.equals(Content.class)) {
            Content.ContentBuilder contentBuilder = Content.builder().id(ContentId.deserialise((String)key)).status(status);
            if (version != null) {
                contentBuilder.version(Version.builder().number(version.intValue()).build());
            }
            return contentBuilder.build();
        }
        throw new BadRequestException("Expected a user, space or content as the " + side);
    }

    private static Class getRelatableClass(String type, String side) {
        if (type.equalsIgnoreCase("user")) {
            return User.class;
        }
        if (type.equalsIgnoreCase("space")) {
            return Space.class;
        }
        if (type.equalsIgnoreCase("content")) {
            return Content.class;
        }
        throw new BadRequestException("Expected user, space or content as the " + side);
    }

    private User buildLookupUser(String userKey) {
        if (Strings.isNullOrEmpty((String)userKey)) {
            throw new BadRequestException("userKey parameter is required but was empty");
        }
        if (userKey.equals("current")) {
            Person person = this.personService.getCurrentUser(new Expansion[0]);
            if (person instanceof Anonymous) {
                throw new PermissionException("Client must be authenticated to access this resource");
            }
            if (!(person instanceof User)) {
                throw new BadRequestException("Expected userKey to describe a User, but was " + person.getClass().getName());
            }
            return (User)person;
        }
        return new User(null, null, new UserKey(userKey), Reference.empty(Icon.class));
    }
}

