/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.experimental.resources;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.SynchronyRowsCount;
import com.atlassian.confluence.api.model.eviction.SynchronyDatasetSize;
import com.atlassian.confluence.api.model.eviction.SynchronyEvictionResult;
import com.atlassian.confluence.api.service.eviction.SynchronyDataService;
import com.atlassian.confluence.rest.v2.api.model.HardEvictionParams;
import com.atlassian.confluence.rest.v2.api.model.SoftEvictionParams;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalApi
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/collab/history")
public class SynchronyDataEvictionResource {
    private final SynchronyDataService synchronyDataService;
    private final Logger logger = LoggerFactory.getLogger(SynchronyDataEvictionResource.class);

    @Inject
    public SynchronyDataEvictionResource(@ComponentImport SynchronyDataService synchronyDataService) {
        this.synchronyDataService = synchronyDataService;
    }

    @POST
    @Path(value="evict/soft")
    @ScopesAllowed(requiredScope={"WRITE"})
    public SynchronyEvictionResult performSoftDataEviction(SoftEvictionParams params) {
        try {
            this.synchronyDataService.softRemoveHistoryOlderThan(params.getThresholdHours(), params.getLimit());
            return SynchronyEvictionResult.ok();
        }
        catch (RuntimeException e) {
            this.logger.error("Soft eviction has been failed", (Throwable)e);
            return SynchronyEvictionResult.failed();
        }
    }

    @POST
    @Path(value="evict/hard")
    @ScopesAllowed(requiredScope={"WRITE"})
    public SynchronyEvictionResult performHardDataEviction(HardEvictionParams params) {
        try {
            this.synchronyDataService.hardRemoveHistoryOlderThan(params.getThresholdHours());
            return SynchronyEvictionResult.ok();
        }
        catch (RuntimeException e) {
            this.logger.error("Hard eviction has been failed", (Throwable)e);
            return SynchronyEvictionResult.failed();
        }
    }

    @GET
    @Path(value="count")
    @ScopesAllowed(requiredScope={"READ"})
    public SynchronyDatasetSize currentDataSize(@QueryParam(value="contentId") @Nullable Long contentId) {
        SynchronyRowsCount dataCount = this.synchronyDataService.currentSynchronyDatasetSize(contentId);
        return new SynchronyDatasetSize(dataCount.getNumberOfEvents(), dataCount.getNumberOfSnapshots());
    }
}

