/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.experimental.resources;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.template.ContentBlueprintInstance;
import com.atlassian.confluence.api.model.content.template.ContentTemplate;
import com.atlassian.confluence.api.model.content.template.ContentTemplateId;
import com.atlassian.confluence.api.model.content.template.ContentTemplateType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.template.ContentTemplateService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@ExperimentalApi
@AnonymousSiteAccess
@LimitRequestSize(value=0x500000L)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/template")
public class TemplateResource {
    private static final String DEFAULT_EXPANSIONS = "body";
    private final ContentTemplateService contentTemplateService;

    @Inject
    public TemplateResource(ContentTemplateService contentTemplateService) {
        this.contentTemplateService = contentTemplateService;
    }

    @GET
    @Path(value="blueprint")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<ContentTemplate> getBlueprintTemplates(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="expand") @DefaultValue(value="") String expand, @Context UriInfo uriInfo) {
        return this.getTemplates(ContentTemplateType.BLUEPRINT, spaceKey, start, limit, expand, uriInfo);
    }

    @GET
    @Path(value="page")
    @ScopesAllowed(requiredScope={"READ"})
    public PageResponse<ContentTemplate> getContentTemplates(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="expand") @DefaultValue(value="") String expand, @Context UriInfo uriInfo) {
        return this.getTemplates(ContentTemplateType.PAGE, spaceKey, start, limit, expand, uriInfo);
    }

    private PageResponse<ContentTemplate> getTemplates(ContentTemplateType templateType, String spaceKey, int start, int limit, String expand, UriInfo uriInfo) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        Optional space = StringUtils.isNotEmpty((CharSequence)spaceKey) ? Optional.of(Space.builder().key(spaceKey).build()) : Optional.empty();
        PageResponse result = this.contentTemplateService.getTemplates(templateType, space, (PageRequest)pageRequest, expansions);
        return RestList.createRestList((PageRequest)pageRequest.copyWithLimits(result), (PageResponse)result);
    }

    @GET
    @Path(value="{contentTemplateId}")
    @ScopesAllowed(requiredScope={"READ"})
    public ContentTemplate getContentTemplate(@PathParam(value="contentTemplateId") ContentTemplateId id, @QueryParam(value="expand") @DefaultValue(value="body") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.contentTemplateService.getTemplate(id, expansions);
    }

    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public ContentTemplate createContentTemplate(ContentTemplate contentTemplate, @QueryParam(value="expand") @DefaultValue(value="body") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.contentTemplateService.create(contentTemplate, expansions);
    }

    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    public ContentTemplate updateContentTemplate(ContentTemplate contentTemplate, @QueryParam(value="expand") @DefaultValue(value="body") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.contentTemplateService.update(contentTemplate, expansions);
    }

    @DELETE
    @Path(value="/{contentTemplateId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response removeTemplate(@PathParam(value="contentTemplateId") ContentTemplateId contentTemplateId) {
        this.contentTemplateService.delete(contentTemplateId);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/page/{contentTemplateId}/instance")
    @ScopesAllowed(requiredScope={"WRITE"})
    public ContentBlueprintInstance createInstance(ContentBlueprintInstance contentBlueprintInstance, @PathParam(value="contentTemplateId") ContentTemplateId contentTemplateId, @QueryParam(value="expand") @DefaultValue(value="body") String expand) {
        this.validateContentTemplateIdMatchesInstance(contentTemplateId, contentBlueprintInstance);
        return this.contentTemplateService.createInstance(contentBlueprintInstance, ExpansionsParser.parse((String)expand));
    }

    private void validateContentTemplateIdMatchesInstance(ContentTemplateId contentTemplateId, ContentBlueprintInstance contentBlueprintInstance) {
        Optional templateId = contentBlueprintInstance.getContentBlueprintSpec().contentTemplateId();
        if (templateId.isPresent() && !((ContentTemplateId)templateId.get()).equals((Object)contentTemplateId)) {
            throw new BadRequestException("Template Id posted in instance doesn't match template id set on path");
        }
    }
}

