/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.RestEntityEnrichmentManager;
import com.atlassian.confluence.rest.serialization.jackson2.enrich.SchemaType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;

@Priority(value=5000)
public class EnricherResourceFilter
implements ContainerResponseFilter {
    private final RestEntityEnrichmentManager enricherVisitor;

    public EnricherResourceFilter(@ComponentImport RestEntityEnrichmentManager enricherVisitor) {
        this.enricherVisitor = enricherVisitor;
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        Object entity = containerResponseContext.getEntity();
        if (entity == null && containerResponseContext.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
            containerResponseContext.setEntity((Object)"");
            return;
        }
        Object restEntity = this.enricherVisitor.convertAndEnrich(entity, SchemaType.REST);
        containerResponseContext.setEntity(restEntity);
    }

    @VisibleForTesting
    RestEntityEnrichmentManager getEnricherVisitor() {
        return this.enricherVisitor;
    }
}

