/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.confluence.api.service.exceptions.ContentTooLongException;
import com.atlassian.confluence.plugins.restapi.filters.util.LimitedInputStream;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.io.IOException;
import java.io.InputStream;

public class LimitingRequestFilter
implements ContainerRequestFilter {
    static final String REQUEST_MAXSIZE_SYSTEM_PROPERTY = "atlassian.rest.request.maxsize";
    public static final long REQUEST_MAXSIZE_DEFAULT_BYTES = 65536L;
    public static final long REQUEST_MAXSIZE_LARGE_BYTES = 0x500000L;
    private final long limit;

    public LimitingRequestFilter(long limit) {
        this.limit = limit;
    }

    long getLimit() {
        return this.limit;
    }

    public void filter(ContainerRequestContext context) {
        InputStream limitedStream = this.limit(context.getEntityStream(), this.limit);
        context.setEntityStream(limitedStream);
    }

    private InputStream limit(InputStream stream, long byteLimit) {
        return new LimitedInputStream(this, stream, byteLimit){

            @Override
            protected void raiseError(long pSizeMax, long pCount) throws IOException {
                throw new ContentTooLongException(String.format("Request too large. Requests for this resource can be at most %s bytes", pSizeMax));
            }
        };
    }
}

