/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.plugins.restapi.annotations.ResourceAnnotationUtil;
import com.atlassian.confluence.plugins.restapi.filters.LogRequestInfoFilter;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.sal.api.user.UserManager;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Objects;

public class LogRequestInfoDynamicFeature
implements DynamicFeature {
    private static final String LOG_REQUEST_INFO = LogRequestInfo.class.getSimpleName();
    private final UserManager userManager;

    public LogRequestInfoDynamicFeature(UserManager userManager) {
        this.userManager = Objects.requireNonNull(userManager);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        if (ResourceAnnotationUtil.hasAnnotation(resourceInfo, LOG_REQUEST_INFO)) {
            featureContext.register((Object)new LogRequestInfoFilter(this.userManager, this.getHeaderNames(resourceInfo), this.getMethods(resourceInfo)));
        }
    }

    @VisibleForTesting
    String[] getHeaderNames(ResourceInfo resourceInfo) {
        if (ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceMethod(), LOG_REQUEST_INFO)) {
            return resourceInfo.getResourceMethod().getAnnotation(LogRequestInfo.class).headerNames();
        }
        return resourceInfo.getResourceClass().getAnnotation(LogRequestInfo.class).headerNames();
    }

    @VisibleForTesting
    String[] getMethods(ResourceInfo resourceInfo) {
        if (ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceClass(), LOG_REQUEST_INFO)) {
            return resourceInfo.getResourceClass().getAnnotation(LogRequestInfo.class).methods();
        }
        return new String[0];
    }
}

