/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRequestInfoFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LogRequestInfoFilter.class);
    private final UserManager userManager;
    private final String[] headerNames;
    private final List<String> methods;

    public LogRequestInfoFilter(UserManager userManager, String[] headerNames, String[] methods) {
        this.userManager = Objects.requireNonNull(userManager);
        this.headerNames = (String[])Arrays.stream(headerNames).map(String::toLowerCase).toArray(String[]::new);
        this.methods = Arrays.stream(methods).map(String::toUpperCase).toList();
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (!this.methods.contains(containerRequestContext.getMethod())) {
            return;
        }
        UriInfo uriInfo = containerRequestContext.getUriInfo();
        UserKey userKey = this.userManager.getRemoteUserKey();
        String userKeyAsString = userKey != null ? userKey.getStringValue() : "anonymous";
        String uuid = UUID.randomUUID().toString();
        StringBuilder pathWithQueryParams = new StringBuilder(uriInfo.getRequestUri().getPath());
        if (uriInfo.getRequestUri().getQuery() != null) {
            pathWithQueryParams.append("?").append(uriInfo.getRequestUri().getQuery());
        }
        log.info("UUID: {} - Request path: {} - User: {} - Method: {}", new Object[]{uuid, pathWithQueryParams, userKeyAsString, containerRequestContext.getMethod()});
        MultivaluedMap headers = containerRequestContext.getHeaders();
        for (String headerName : this.headerNames) {
            List values = (List)headers.get((Object)headerName);
            if (values == null || values.isEmpty()) continue;
            log.info("UUID: {} - Header: {} -> [{}]", new Object[]{uuid, headerName, String.join((CharSequence)", ", values)});
        }
    }
}

