/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.RateLimiter;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitFilter
implements ContainerRequestFilter {
    private static final String ANONYMOUS_USER_NAME = "__anonymous__";
    private static final int DEFAULT_CACHE_EXPIRY_MINUTES = 20;
    private static final Logger log = LoggerFactory.getLogger(RateLimitFilter.class);
    private static final String RATE_LIMIT_CACHE_EXPIRY_PROPERTY_NAME = "confluence.rate.limit.cache.expiry.minutes";
    private final Cache<String, RateLimiter> limiterCache;
    private final double permitsPerSecond;
    private final RateLimited.Type type;
    private final Set<String> scopes;
    private final PersonService personService;
    private final ConfluenceScopesRequestCache scopesRequestCache;

    public RateLimitFilter(double permitsPerSecond, RateLimited.Type type, Set<String> scopes, PersonService personService, ConfluenceScopesRequestCache scopesRequestCache) {
        this.permitsPerSecond = permitsPerSecond;
        this.personService = personService;
        this.limiterCache = CacheBuilder.newBuilder().expireAfterAccess(this.getCacheExpiryLimitValue(), TimeUnit.MINUTES).build();
        this.type = type;
        this.scopesRequestCache = scopesRequestCache;
        this.scopes = scopes;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Optional<String> maybeUserName = this.getCurrentUserName();
        try {
            if (this.type == RateLimited.Type.TWO_LO) {
                Set<String> matchingScopes = this.getMatchingScopes();
                if (maybeUserName.isEmpty() && !matchingScopes.isEmpty() && !((RateLimiter)this.limiterCache.get((Object)(ANONYMOUS_USER_NAME + matchingScopes.iterator().next()), () -> RateLimiter.create((double)this.permitsPerSecond))).tryAcquire()) {
                    requestContext.abortWith(this.getRateLimitedResponse());
                }
            } else if (this.type == RateLimited.Type.ALL) {
                Set<String> matchingScopes = this.getMatchingScopes();
                Object username = maybeUserName.isPresent() ? maybeUserName.get() : (!matchingScopes.isEmpty() ? ANONYMOUS_USER_NAME + matchingScopes.iterator().next() : ANONYMOUS_USER_NAME);
                if (!((RateLimiter)this.limiterCache.get(username, () -> RateLimiter.create((double)this.permitsPerSecond))).tryAcquire()) {
                    requestContext.abortWith(this.getRateLimitedResponse());
                }
            }
        }
        catch (ExecutionException e) {
            log.debug("Error while accessing LIMITER_CACHE", (Throwable)e);
            log.error("Error while accessing LIMITER_CACHE {}", (Object)e.getMessage());
        }
    }

    private Set<String> getMatchingScopes() {
        if (this.scopes.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> matchingScopes = new LinkedHashSet<String>();
        this.scopes.forEach(scope -> {
            if (this.scopesRequestCache.isScopePermitted(scope)) {
                matchingScopes.add((String)scope);
            }
        });
        return matchingScopes;
    }

    private Optional<String> getCurrentUserName() {
        Person person = this.personService.getCurrentUser(new Expansion[0]);
        return person.optionalUsername();
    }

    private long getCacheExpiryLimitValue() {
        try {
            return Long.parseLong(System.getProperty(RATE_LIMIT_CACHE_EXPIRY_PROPERTY_NAME, String.valueOf(20)));
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse confluence.rate.limit.cache.expiry.minutes property", (Throwable)e);
            return 20L;
        }
    }

    private Response getRateLimitedResponse() {
        return Response.status((Response.Status)Response.Status.TOO_MANY_REQUESTS).header("Retry-After", (Object)this.getRetryAfter()).entity((Object)"{rateLimited: true}").build();
    }

    private int getRetryAfter() {
        if (this.permitsPerSecond >= 1.0) {
            return 1;
        }
        return (int)Math.ceil(1.0 / this.permitsPerSecond);
    }

    @VisibleForTesting
    public double getPermitsPerSecond() {
        return this.permitsPerSecond;
    }

    @VisibleForTesting
    public RateLimited.Type getType() {
        return this.type;
    }

    @VisibleForTesting
    public Set<String> getScopes() {
        return Collections.unmodifiableSet(this.scopes);
    }
}

