/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.plugins.restapi.annotations.ResourceAnnotationUtil;
import com.atlassian.confluence.plugins.restapi.filters.ReadOnlyAccessRequestFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;

public class ReadOnlyAccessDynamicFeature
implements DynamicFeature {
    private final AccessModeService accessModeService;
    private static final String READ_ONLY_ACCESS_ALLOWED_ANNOTATION = "ReadOnlyAccessAllowed";
    private static final String READ_ONLY_ACCESS_BLOCKED_ANNOTATION = "ReadOnlyAccessBlocked";

    public ReadOnlyAccessDynamicFeature(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        if (this.hasReadOnlyAccessAllowedAnnotation(resourceInfo)) {
            return;
        }
        featureContext.register((Object)new ReadOnlyAccessRequestFilter(this.accessModeService, this.hasReadOnlyAccessBlockedAnnotation(resourceInfo)));
    }

    private boolean hasReadOnlyAccessAllowedAnnotation(ResourceInfo resourceInfo) {
        return ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceMethod(), READ_ONLY_ACCESS_ALLOWED_ANNOTATION) || ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceClass(), READ_ONLY_ACCESS_ALLOWED_ANNOTATION) || ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceClass().getPackage(), READ_ONLY_ACCESS_ALLOWED_ANNOTATION);
    }

    private boolean hasReadOnlyAccessBlockedAnnotation(ResourceInfo resourceInfo) {
        return ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceMethod(), READ_ONLY_ACCESS_BLOCKED_ANNOTATION) || ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceClass(), READ_ONLY_ACCESS_BLOCKED_ANNOTATION) || ResourceAnnotationUtil.isAnnotated(resourceInfo.getResourceClass().getPackage(), READ_ONLY_ACCESS_BLOCKED_ANNOTATION);
    }
}

