/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.core.util.ClassLoaderUtils;
import com.google.common.collect.Lists;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyAccessRequestFilter
implements ContainerRequestFilter {
    private final AccessModeService accessModeService;
    private final boolean hasReadOnlyAccessBlockedAnnotation;
    private Optional<List<String>> whiteListCache = Optional.empty();
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyAccessRequestFilter.class);
    private final List<String> whiteList = Lists.newArrayList((Object[])new String[]{"/backdoor/", "/webResources/", "/wrm/", "/analytics/", "/plugins/", "/whitelist/", "/applinks/", "/applinks-oauth/", "/hipchat/", "/nativemobile/", "/custom-apps/", "/troubleshooting/", "/nps/", "/tsv/"});

    public ReadOnlyAccessRequestFilter(AccessModeService accessModeService, boolean hasReadOnlyAccessBlockedAnnotation) {
        this.accessModeService = accessModeService;
        this.hasReadOnlyAccessBlockedAnnotation = hasReadOnlyAccessBlockedAnnotation;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if (!this.accessModeService.isReadOnlyAccessModeEnabled()) {
            return;
        }
        if (this.hasReadOnlyAccessBlockedAnnotation) {
            throw new ReadOnlyException();
        }
        String basePath = containerRequestContext.getUriInfo().getBaseUri().getPath();
        if (this.isWhitelisted(basePath)) {
            return;
        }
        if (this.isMutativeMethod(containerRequestContext.getMethod())) {
            throw new ReadOnlyException();
        }
    }

    private boolean isMutativeMethod(String method) {
        return StringUtils.equalsAny((CharSequence)method, (CharSequence[])new CharSequence[]{"POST", "PUT", "DELETE"});
    }

    private boolean isWhitelisted(String basePath) {
        return StringUtils.containsAny((CharSequence)basePath, (CharSequence[])this.getReadOnlyRestWhitelist());
    }

    private String[] getReadOnlyRestWhitelist() {
        if (this.whiteListCache.isEmpty()) {
            URL whitelistUrl = ClassLoaderUtils.getResource((String)"read-only-rest-whitelist.txt", AccessModeService.class);
            if (whitelistUrl != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(whitelistUrl.openStream(), StandardCharsets.UTF_8));){
                    reader.lines().forEach(this.whiteList::add);
                }
                catch (Exception e) {
                    log.error("An error has occurred while reading read-only-rest-whitelist.txt");
                    log.debug("", (Throwable)e);
                }
            }
            this.whiteListCache = Optional.of(this.whiteList);
        }
        return this.whiteListCache.get().toArray(new String[0]);
    }
}

