/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.plugins.restapi.filters.RateLimitFilter;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@Priority(value=999)
public class RequestRateLimitDynamicFeature
implements DynamicFeature {
    private final PersonService personService;
    private final ConfluenceScopesRequestCache scopesRequestCache;

    public RequestRateLimitDynamicFeature(PersonService personService, ConfluenceScopesRequestCache scopesRequestCache) {
        this.personService = Objects.requireNonNull(personService);
        this.scopesRequestCache = Objects.requireNonNull(scopesRequestCache);
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        double permitsPerSecond = this.getRateLimit(resourceInfo);
        if (permitsPerSecond > 0.0) {
            Set<String> allowedScopes = this.getScopes(resourceInfo);
            RateLimited.Type requestType = this.getRequestType(resourceInfo);
            context.register((Object)new RateLimitFilter(permitsPerSecond, requestType, allowedScopes, this.personService, this.scopesRequestCache));
        }
    }

    private RateLimited.Type getRequestType(ResourceInfo resourceInfo) {
        RateLimited annotation = RequestRateLimitDynamicFeature.getAnnotation(resourceInfo, RateLimited.class);
        if (annotation != null) {
            return annotation.type();
        }
        return null;
    }

    private Set<String> getScopes(ResourceInfo resourceInfo) {
        ScopesAllowed annotation = RequestRateLimitDynamicFeature.getAnnotation(resourceInfo, ScopesAllowed.class);
        LinkedHashSet<String> scopes = new LinkedHashSet<String>();
        if (annotation != null) {
            scopes.addAll(Arrays.stream(annotation.requiredScope()).toList());
        }
        return scopes;
    }

    private double getRateLimit(ResourceInfo resourceInfo) {
        double permitsPerSecond = 0.0;
        RateLimited annotation = RequestRateLimitDynamicFeature.getAnnotation(resourceInfo, RateLimited.class);
        if (annotation != null && (permitsPerSecond = this.getRateLimitFromTheProperty(resourceInfo, annotation)) < 0.0) {
            Class resourceClass = resourceInfo.getResourceClass();
            Method method = resourceInfo.getResourceMethod();
            if (method.isAnnotationPresent(RateLimited.class)) {
                permitsPerSecond = method.getAnnotation(RateLimited.class).permitsPerSecond();
            } else if (resourceClass.isAnnotationPresent(RateLimited.class)) {
                permitsPerSecond = resourceClass.getAnnotation(RateLimited.class).permitsPerSecond();
            }
        }
        return permitsPerSecond;
    }

    private static <T extends Annotation> T getAnnotation(ResourceInfo resourceInfo, Class<T> annotationClass) {
        Class resourceClass = resourceInfo.getResourceClass();
        Method method = resourceInfo.getResourceMethod();
        if (method.isAnnotationPresent(annotationClass)) {
            return method.getAnnotation(annotationClass);
        }
        if (resourceClass.isAnnotationPresent(annotationClass)) {
            return resourceClass.getAnnotation(annotationClass);
        }
        return null;
    }

    private double getRateLimitFromTheProperty(ResourceInfo resourceInfo, RateLimited annotation) {
        Object propertyName;
        if (StringUtils.isBlank((CharSequence)annotation.propertyName())) {
            Class resourceClass = resourceInfo.getResourceClass();
            Method method = resourceInfo.getResourceMethod();
            propertyName = "confluence.rest.rate.limit." + resourceClass.getName().toLowerCase() + "." + method.getName().toLowerCase();
        } else {
            propertyName = annotation.propertyName();
        }
        return Double.parseDouble(System.getProperty((String)propertyName, "-1"));
    }
}

