/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.filters;

import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.plugins.restapi.filters.LimitingRequestFilter;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.reflect.Method;

@Priority(value=1000)
public class RequestSizeLimitingDynamicFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        if (RequestSizeLimitingDynamicFeature.hasLimitRequestSizeAnnotation(resourceInfo)) {
            long limit = RequestSizeLimitingDynamicFeature.getRequestSizeLimit(resourceInfo);
            featureContext.register((Object)new LimitingRequestFilter(limit));
        }
    }

    private static long getRequestSizeLimit(ResourceInfo resourceInfo) {
        long limit = RequestSizeLimitingDynamicFeature.hasLimitRequestSizeAnnotationOnMethod(resourceInfo.getResourceMethod()) ? resourceInfo.getResourceMethod().getAnnotation(LimitRequestSize.class).value() : resourceInfo.getResourceClass().getAnnotation(LimitRequestSize.class).value();
        return RequestSizeLimitingDynamicFeature.getRequestSizeLimit(limit);
    }

    static long getRequestSizeLimit(long limit) {
        if (limit < 65536L) {
            limit = 65536L;
        }
        return Math.max(limit, Long.getLong("atlassian.rest.request.maxsize", limit));
    }

    private static boolean hasLimitRequestSizeAnnotation(ResourceInfo resourceInfo) {
        return RequestSizeLimitingDynamicFeature.hasLimitRequestSizeAnnotationOnMethod(resourceInfo.getResourceMethod()) || resourceInfo.getResourceClass().isAnnotationPresent(LimitRequestSize.class) || resourceInfo.getResourceClass().getPackage().isAnnotationPresent(LimitRequestSize.class);
    }

    private static boolean hasLimitRequestSizeAnnotationOnMethod(Method abstractMethod) {
        return abstractMethod.isAnnotationPresent(LimitRequestSize.class);
    }
}

