/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.metadata.content;

import com.atlassian.confluence.api.extension.MetadataProperty;
import com.atlassian.confluence.api.extension.ModelMetadataProvider;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.service.content.ContentLabelService;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.services.RestNavigationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class LabelsModelMetadataProvider
implements ModelMetadataProvider {
    private static final String LABELS_EXPAND = "labels";
    private final ContentLabelService contentLabelService;
    private final NavigationService navigationService;

    public LabelsModelMetadataProvider(@ComponentImport ContentLabelService contentLabelService, @ComponentImport RestNavigationService navigationService) {
        this.contentLabelService = contentLabelService;
        this.navigationService = navigationService;
    }

    private Map<String, ?> getMetadata(Content content) {
        Navigation.Builder navBuilder = this.navigationService.createNavigation().content(content).label();
        PageRequest request = navBuilder.createPageRequest(0, Integer.MAX_VALUE);
        PageResponse response = this.contentLabelService.getLabels(content.getId(), List.of(Label.Prefix.global), request);
        return Map.of(LABELS_EXPAND, RestList.createRestList((PageRequest)navBuilder.createPageRequest(response.getPageRequest()), (PageResponse)response));
    }

    public Map<Object, Map<String, ?>> getMetadataForAll(Iterable<Object> entities, Expansions expansions) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Object entity : entities) {
            try {
                if (!(entity instanceof Content)) continue;
                Content content = (Content)entity;
                mapBuilder.put((Object)content, this.getMetadata(content));
            }
            catch (NotFoundException notFoundException) {}
        }
        return mapBuilder.build();
    }

    public List<String> getMetadataProperties() {
        return List.of(LABELS_EXPAND);
    }

    public List<MetadataProperty> getProperties() {
        return List.of(new MetadataProperty(LABELS_EXPAND, new TypeToken<List<Label>>(){}.getType()));
    }
}

