/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Produces(value={"application/json"})
@Path(value="/accessmode")
@Tag(name="Access Mode")
public class AccessModeResource {
    private final AccessModeService accessModeService;

    @Inject
    public AccessModeResource(@ComponentImport AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    @Operation(description="Returns the access mode status for Confluence.", summary="Get access mode status")
    @ApiResponse(responseCode="200", description="Returns the access mode status for Confluence. Example: READ_WRITE", content={@Content(mediaType="application/json", examples={@ExampleObject(value="READ_WRITE")})})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public Response getAccessModeStatus() {
        return Response.ok((Object)this.accessModeService.getAccessMode()).build();
    }
}

