/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@Path(value="/admin/group")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@LimitRequestSize(value=65536L)
@WebSudoRequired
@SystemAdminOnly
@SendsAnalytics
@Tag(name="Admin Group")
public final class AdminGroupResource {
    private final GroupService groupService;

    @Inject
    public AdminGroupResource(@ComponentImport GroupService groupService) {
        this.groupService = groupService;
    }

    @Operation(description="Creates the given group identified by name.", summary="Create group")
    @RequestBody(content={@Content(schema=@Schema(implementation=Group.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="returns the new group if group is created successfully", responseCode=200, representation=Group.class), @ResponseDoc(documentation="returned if request does not provide a name", responseCode=400, restError=true), @ResponseDoc(documentation="returned if user does not have enough permission", responseCode=403, restError=true), @ResponseDoc(documentation="returned if group with the same name already exists", responseCode=409, restError=true)})
    @POST
    public Response create(Group model) throws URISyntaxException, UnsupportedEncodingException {
        Group group = this.groupService.createGroup(model.getName());
        String encodedName = URLEncoder.encode(group.getName(), StandardCharsets.UTF_8);
        URI location = new URI(encodedName);
        return Response.created((URI)location).entity((Object)group).build();
    }

    @Operation(description="Deletes the given group identified by name.", summary="Delete group")
    @Parameter(name="groupName", description="the group name to be deleted", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="returns no content if group is deleted successfully", responseCode=204), @ResponseDoc(documentation="returned if user is attempting to delete the last admin group", responseCode=400, restError=true), @ResponseDoc(documentation="returned if user does not have correct permission", responseCode=403, restError=true), @ResponseDoc(documentation="returned if group cannot be found", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{groupName}")
    public Response delete(@PathParam(value="groupName") String groupName) {
        this.groupService.deleteGroup(groupName);
        return Response.noContent().build();
    }
}

