/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.api.model.content.PersonalSpaceDetailsForCreation;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;

@Path(value="/admin/space")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@AdminOnly
@SendsAnalytics
@Tag(name="Admin Space")
public final class AdminSpaceResource {
    private final SpaceService spaceService;

    @Inject
    public AdminSpaceResource(@ComponentImport SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @Operation(summary="Creates personal Space for a User.", description="Creates a personal space for a user.\n\nExample request URI: \n\n`http://example.com/confluence/rest/api/admin/space/personal/morganlee`")
    @RequestBody(description="The personal space to be created", required=true, content={@Content(schema=@Schema(implementation=PersonalSpaceDetailsForCreation.class))})
    @Parameter(name="username", description="the username of the user to create personal space for.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a space.", responseCode=200, representation=Space.class), @ResponseDoc(documentation="Returned if current user does not have correct permission.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is invalid space description.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if target user not found by username.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if personal space already exists for target user.", responseCode=409, restError=true)})
    @POST
    @Path(value="personal/{username}")
    @Consumes(value={"application/json"})
    @PublicApi
    public Space createPersonalSpace(@PathParam(value="username") String username, PersonalSpaceDetailsForCreation newSpaceDetail) throws ServiceException {
        return this.spaceService.createPersonalSpaceForUser(newSpaceDetail, username);
    }
}

