/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.people.Credentials;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.people.UserDetailsForCreation;
import com.atlassian.confluence.api.model.people.UserDetailsForUpdate;
import com.atlassian.confluence.api.model.people.UserKey;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.plugins.restapi.resources.LongTaskResource;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

@Path(value="/admin/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@AdminOnly
@SendsAnalytics
@Tag(name="Admin User")
public final class AdminUserResource {
    private final PersonService personService;

    @Inject
    public AdminUserResource(@ComponentImport PersonService personService) {
        this.personService = personService;
    }

    @Operation(description="One of the following options could be used:\n\n1. Create a user with a specified password. The userName, fullName, email and password needs to be specified.\n\n2. Create a user with an email notification to the user. The userName, fullName, email and notifyViaEmail (true) needs to be specified.\n\n**Requirements**:\n\n- The userName should not be null or blank\n\n- The userName should not contain any of these characters \\ , + < > ' \"\n\n- The userName should not contain any whitespace characters\n\n- The userName should not be \"anonymous\"\n\n- The userName should not contain any upper case characters\n\n- The fullName should not be null or blank\n\n- The fullName should not contain any of these characters\n\n- The fullName should not be \"anonymous\"\n\n- The email should not be null or blank\n\n- The email should be a valid email address\n\n- If notifyViaEmail is false then the password should not be null or blank\n\n- If notifyViaEmail is true then the password should not be specified", summary="Create user")
    @RequestBody(content={@Content(schema=@Schema(implementation=UserDetailsForCreation.class))}, description="Details of the user to be created")
    @ResponseDocs(value={@ResponseDoc(documentation="returns a response with generated UserKey for the created user.", responseCode=201, representation=UserKey.class), @ResponseDoc(documentation="returned if any error occurs while creating the user", responseCode=400, restError=true), @ResponseDoc(documentation="returned if an anonymous (or unauthenticated) user tries to create a user", responseCode=401, restError=true), @ResponseDoc(documentation="returned if no more licenses available to create a user", responseCode=402, restError=true), @ResponseDoc(documentation="returned if user does not have enough permission to create a user", responseCode=403, restError=true), @ResponseDoc(documentation="returned if the user with the same userName already exists", responseCode=409, restError=true)})
    @POST
    public Response createUser(UserDetailsForCreation userDetailsForCreation) throws URISyntaxException, UnsupportedEncodingException {
        UserKey userKey = this.personService.create(userDetailsForCreation);
        String encodedName = URLEncoder.encode(userDetailsForCreation.getUserName(), StandardCharsets.UTF_8);
        URI location = new URI(encodedName);
        return Response.created((URI)location).entity((Object)userKey).build();
    }

    @Operation(description="Updates the user identified by the username. The following fields can be updated: email, full name.\n\"**Requirements**:\n- The fullName should not be blank\n- The fullName should not contain any forbidden characters (< or >)\n- The fullName should not be anonymous (in english or other system locale)\n- The email should not be blank\n- The email should be a valid email address\n", summary="Update user")
    @RequestBody(content={@Content(schema=@Schema(implementation=UserDetailsForUpdate.class))}, description="Details of the user to be updated")
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the update was successful.", responseCode=204, representation=UserKey.class), @ResponseDoc(documentation="returned if any error occurs while updating the user", responseCode=400, restError=true), @ResponseDoc(documentation="returned if an anonymous (or unauthenticated) user tries to update a user", responseCode=401, restError=true), @ResponseDoc(documentation="returned if user does not have enough permission to update a user", responseCode=403, restError=true)})
    @PUT
    @Path(value="/{username}")
    public Response updateUser(@PathParam(value="username") String username, UserDetailsForUpdate userDetailsForUpdate) {
        this.personService.update(username, userDetailsForUpdate);
        return Response.noContent().build();
    }

    @Operation(description="Disables the given User identified by username. This method is idempotent i.e. if the user is already disabled then no action will be taken.", summary="Disable user")
    @Parameter(name="username", description="the username identifying the given user", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="returns no content if the user is disabled"), @ResponseDoc(documentation="The calling user is not authenticated or does not have the <b>LICENSED</b> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The calling user does not have permission to perform this action.", responseCode=403, restError=true), @ResponseDoc(documentation="No User exists for the provided username.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{username}/disable")
    public Response disable(@PathParam(value="username") String username) {
        this.personService.disable(username);
        return Response.noContent().build();
    }

    @Operation(description="Enables the given User identified by username. This method is idempotent i.e. if the user is already enabled then no action will be taken.", summary="Enable user")
    @Parameter(name="username", description="the username identifying the given user", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="returns no content if the user is enabled"), @ResponseDoc(documentation="The calling user is not authenticated or does not have the <b>LICENSED</b> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The calling user does not have permission to perform this action.", responseCode=403, restError=true), @ResponseDoc(documentation="No User exists for the provided username.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{username}/enable")
    public Response enable(@PathParam(value="username") String username) {
        this.personService.enable(username);
        return Response.noContent().build();
    }

    @Operation(description="Deletes the given User identified by username. This action is processed asynchronously.", summary="Delete user")
    @Parameter(name="username", description="the username identifying the given user", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(responseCode=202, representation=LongTaskSubmission.class, documentation="Produces a HTTP Accept 202 response from some other resource pointing to this class's LongTaskStatus resource."), @ResponseDoc(documentation="The calling user is not authenticated or does not have the <b>LICENSED</b> permission.", responseCode=401, restError=true), @ResponseDoc(documentation="The calling user does not have permission to perform this action.", responseCode=403, restError=true), @ResponseDoc(documentation="No User exists for the provided username.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{username}")
    public Response delete(@PathParam(value="username") String username) {
        Person person = (Person)this.personService.find(new Expansion[0]).withUsername(username).fetchOrNull();
        LongTaskSubmission task = this.personService.delete(person);
        return LongTaskResource.submissionResponse(task);
    }

    @Operation(description="Change the password for the user identified by the username. \n\n**Validation rules** : \n\n- The new password should not be null or blank. \n\n", summary="Change password")
    @Parameters(value={@Parameter(name="username", description="the username identifying the given user", in=ParameterIn.PATH), @Parameter(name="credentials", description="New password for the user")})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="returns no content if the password is changed successfully"), @ResponseDoc(responseCode=400, documentation="returned if any error occurs while changing user password. Refer to the validation rules above.", restError=true), @ResponseDoc(responseCode=403, documentation="returned if user does not have enough permission to change another user's password. User should be a System admin", restError=true), @ResponseDoc(responseCode=404, documentation="returned if user with specified userName not found", restError=true)})
    @POST
    @Path(value="/{username}/password")
    public Response changePassword(@PathParam(value="username") String username, Credentials credentials) {
        this.personService.changeUserPassword(username, credentials.getPassword());
        return Response.noContent().build();
    }
}

