/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@Path(value="/admin/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@AdminOnly
@SendsAnalytics
@Tag(name="Admin Users")
public final class AdminUsersResource {
    private final PersonService personService;

    @Inject
    public AdminUsersResource(@ComponentImport PersonService personService) {
        this.personService = personService;
    }

    @Operation(summary="Get active users", description="Gets a paginated collection of all active users (users which count into license usage).\nThis will exclude users that are:\n- anonymous,\n- deactivated,\n- externally deleted,\n- shadowed\n- unlicensed\n\nThis feature relies on search index and might not be accurate when site reindex is in progress.\n\nDepending on the type of the user the response can include the following fields:\n- `email`: The user's email address.\n- `lastLogin`: The date and time of the user's last successful login. Required \"lastLogin\" expansion.\n- `type`: The type of user (e.g., `known`, `anonymous`).\n- `username`: The user's username.\n- `userKey`: The unique key identifying the user.\n- `displayName`: The user's full display name.\n\nExample request URI(s):\n`http://example.com/confluence/rest/api/admin/users/list/active`\n`http://example.com/confluence/rest/api/admin/users/list/active?start=0`\n`http://example.com/confluence/rest/api/admin/users/list/active?start=0&limit=100`\n`http://example.com/confluence/rest/api/admin/users/list/active?start=0&limit=100&expand=status`\n")
    @Parameters(value={@Parameter(name="expand", description="properties to expand on the user.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return. This must be non-negative. Default value is 0.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of users to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a paginated collection of users.", responseCode=200, representation=Person.class, paged=true), @ResponseDoc(documentation="Returned if the calling user does not have permission to view users. This is possible for anonymous or un-licensed users.", responseCode=403, restError=true)})
    @GET
    @Path(value="/list/active")
    public PageResponse<Person> getActiveUsers(@QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) {
        RestPageRequest restPageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse users = this.personService.fetchActiveUsers((PageRequest)restPageRequest);
        return RestList.newRestList((PageResponse)users).pageRequest((PageRequest)restPageRequest).build();
    }
}

