/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.AttachmentExtractedText;
import com.atlassian.confluence.api.model.content.AttachmentUpload;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.AttachmentExtractedTextService;
import com.atlassian.confluence.api.service.content.AttachmentService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.settings.SettingsService;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartConfig;
import com.atlassian.plugins.rest.api.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/child/attachment")
@Tag(name="Attachments")
@SendsAnalytics
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class AttachmentResource {
    private static final Logger log = LoggerFactory.getLogger(AttachmentResource.class);
    private static final String DEFAULT_LIMIT = "50";
    private static final long DEFAULT_EXTRACTED_TEXT_LIMIT = 0x200000L;
    private final AttachmentService attachmentService;
    private final AttachmentExtractedTextService attachmentExtractedTextService;

    @Inject
    public AttachmentResource(@ComponentImport AttachmentService attachmentService, @ComponentImport AttachmentExtractedTextService attachmentExtractedTextService, @ComponentImport SettingsService settingsService) {
        this.attachmentService = attachmentService;
        this.attachmentExtractedTextService = attachmentExtractedTextService;
        ConfluenceAttachmentMultipartConfig.settingsService = settingsService;
    }

    @Operation(description="Returns a paginated list of attachment Content entities within a single container.", summary="Get attachment")
    @Parameters(value={@Parameter(name="id", description="The id of the content the attachment is on.", in=ParameterIn.PATH), @Parameter(name="expand", description="(optional) a comma separated list of properties to expand on the Attachments returned.", in=ParameterIn.QUERY), @Parameter(name="start", description="(optional) the index of the first item within the result set that should be returned.", in=ParameterIn.QUERY), @Parameter(name="limit", description="(optional) how many items should be returned after the start index.", in=ParameterIn.QUERY), @Parameter(name="expand", description="(optional) a comma separated list of properties to expand on the Attachments returned. Optional.", in=ParameterIn.QUERY), @Parameter(name="filename", description="(optional) filter parameter to return only the Attachment with the matching file name.", in=ParameterIn.QUERY), @Parameter(name="mediaType", description="(optional) a comma separated list of properties to expand on the Attachments returned.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a JSON representation of a list of attachment Content entities.", responseCode=201, representation=com.atlassian.confluence.api.model.content.Content.class, paged=true), @ResponseDoc(documentation=" Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public RestList<com.atlassian.confluence.api.model.content.Content> getAttachments(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="50") int limit, @QueryParam(value="filename") String filename, @QueryParam(value="mediaType") String mediaType, @Context UriInfo uriInfo) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse content = this.attachmentService.find(expansions).withContainerId(contentId).withFilename(filename).withMediaType(mediaType).fetchMany((PageRequest)request);
        return RestList.createRestList((PageRequest)request, (PageResponse)content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(description="Add one or more attachments to a Confluence Content entity, with optional comments.\n\n**Comments are optional**, but if included there must be as many comments as there are files, and the comments must be in the same order as the files.\n\nThis resource expects a multipart post. The media-type multipart/form-data is defined in RFC 1867. Most client libraries have classes that make dealing with multipart posts simple. For instance, in Java the Apache HTTP Components library provides a `MultiPartEntity` that makes it simple to submit a multipart POST.\n\nIn order to protect against XSRF attacks, because this method accepts multipart/form-data, it has XSRF protection on it. This means you must submit a header of `X-Atlassian-Token: nocheck` with the request, otherwise it will be blocked.\n\nThe name of the multipart/form-data parameter that contains attachments must be 'file'.", summary="Create attachments")
    @Parameters(value={@Parameter(name="id", description="The id of the content the attachment is on.", in=ParameterIn.PATH), @Parameter(name="status", description="a string containing the status of the attachments content container, supports current or draft, defaults to current", in=ParameterIn.QUERY), @Parameter(name="allowDuplicated", description="(optional) allows to upload an attachment with an existing filename.", in=ParameterIn.QUERY), @Parameter(name="expand", description="(optional) a comma separated list of properties to expand on the Attachments returned. Optional.", in=ParameterIn.QUERY)})
    @RequestBody(description="The attachments to be added. The name of the multipart/form-data parameter that contains attachments must be 'file'.", content={@Content(schema=@Schema(implementation=MockAttachmentRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the attachments added.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation=" Returned if the requested content is not found, the user does not have permission to view it, or if the attachments exceeds the maximum configured attachment size.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if attachments is disabled or if you don't have permission to add attachments to this content.", responseCode=403, restError=true)})
    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=ConfluenceAttachmentMultipartConfig.class)
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public RestList<com.atlassian.confluence.api.model.content.Content> createAttachments(@PathParam(value="id") ContentId containerId, @QueryParam(value="status") @DefaultValue(value="current") ContentStatus containerStatus, @QueryParam(value="allowDuplicated") @DefaultValue(value="false") boolean allowDuplicated, @QueryParam(value="expand") @DefaultValue(value="") String expand, @MultipartFormParam(value="file") List<FilePart> fileParts, @MultipartFormParam(value="comment") @Nullable List<FilePart> comments, @MultipartFormParam(value="minorEdit") @Nullable List<FilePart> minorEdits, @MultipartFormParam(value="hidden") @Nullable List<FilePart> hiddens) throws ServiceException {
        int numhiddens;
        int numMinorEdits;
        if (!this.attachmentService.validator().canCreateAttachments(containerId, containerStatus)) {
            throw new PermissionException("User not permitted to create attachments for content: " + String.valueOf(containerId));
        }
        if (fileParts.isEmpty()) {
            throw new BadRequestException("At least one attachment file must be included.");
        }
        int numComments = comments == null ? 0 : comments.size();
        int numAttachments = fileParts.size();
        if (numComments > 0 && numComments != numAttachments) {
            throw new BadRequestException("Must be same number of attachment files and comments.");
        }
        int n = numMinorEdits = minorEdits == null ? 0 : minorEdits.size();
        if (numMinorEdits > 0 && numMinorEdits != numAttachments) {
            throw new BadRequestException("Must have the same number of attachment files and minorEdits flag, or not have any minorEdits flags at all");
        }
        int n2 = numhiddens = hiddens == null ? 0 : hiddens.size();
        if (numhiddens > 0 && numhiddens != numAttachments) {
            throw new BadRequestException("Must have the same number of attachment files and hidden flags, or not have any hidden flags at all");
        }
        Expansions expansions = ExpansionsParser.parseAsExpansions((String)expand);
        List<AttachmentUpload> uploads = this.convertFilePartsToAttachmentUploads(fileParts, comments, minorEdits, hiddens);
        try {
            PageResponse contents = this.attachmentService.addAttachments(containerId, containerStatus, uploads, allowDuplicated, expansions);
            RestList restList = RestList.createRestList((PageResponse)contents);
            return restList;
        }
        finally {
            uploads.stream().map(AttachmentUpload::getFile).forEach(File::delete);
        }
    }

    @Operation(description="Update the non-binary data of an attachment.This resource can be used to update an attachment's filename, media-type, comment, and parent container.", summary="Update non-binary data of an Attachment")
    @Parameters(value={@Parameter(name="id", description="The id of the content the attachment is on.", in=ParameterIn.PATH), @Parameter(name="attachmentId", description="the id of the attachment to update.", in=ParameterIn.PATH), @Parameter(name="attachment", description="the details of the Attachment to be updated.")})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the attachment after being updated.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation=" Returned if no attachment is found for the attachmentId.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if you are not permitted to update or move the attachment to a different container.", responseCode=403, restError=true), @ResponseDoc(documentation=" Returned if the attachment id or the attachment version number are invalid.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the version of the supplied Attachment does not match the exact version of the Attachment stored in the database.", responseCode=409, restError=true)})
    @PUT
    @Path(value="/{attachmentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public com.atlassian.confluence.api.model.content.Content update(@PathParam(value="attachmentId") String attachmentId, com.atlassian.confluence.api.model.content.Content attachment) throws ServiceException {
        return this.attachmentService.update(attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(description="Update the binary data of an Attachment, and optionally the comment and the minor edit field.\n\nThis adds a new version of the attachment, containing the new binary data, filename, and content-type.\n\n**When updating the binary data of an attachment**, the comment related to it together with the field that specifies if it's a minor edit can be updated as well, but are not required.\n\nIf an update is considered to be a minor edit, notifications will not be sent to the watchers of that content.\n\nThis resource expects a multipart post. The media-type multipart/form-data is defined in RFC 1867. Most client libraries have classes that make dealing with multipart posts simple. For instance, in Java the Apache HTTP Components library provides a `MultiPartEntity` that makes it simple to submit a multipart POST.\n\nIn order to protect against XSRF attacks, because this method accepts multipart/form-data, it has XSRF protection on it. This means you must submit a header of `X-Atlassian-Token: nocheck` with the request, otherwise it will be blocked.\n\nThe name of the multipart/form-data parameter that contains attachments must be 'file'.", summary="Update binary data of an attachment")
    @Parameters(value={@Parameter(name="id", description="The id of the content the attachment is on.", in=ParameterIn.PATH), @Parameter(name="attachmentId", description="the id of the attachment to upload the new file for.", in=ParameterIn.PATH)})
    @RequestBody(description="The attachment to be updated.", content={@Content(schema=@Schema(implementation=MockAttachmentRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="returns JSON representation of the updated attachment.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation=" Returned if no attachment is found for the attachmentId.", responseCode=404, restError=true), @ResponseDoc(documentation=" Returned if the attachment id is invalid.", responseCode=400, restError=true)})
    @POST
    @Path(value="/{attachmentId}/data")
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=ConfluenceAttachmentMultipartConfig.class)
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public com.atlassian.confluence.api.model.content.Content updateData(@PathParam(value="attachmentId") ContentId attachmentId, @MultipartFormParam(value="file") FilePart filePart, @MultipartFormParam(value="comment") FilePart comment, @MultipartFormParam(value="minorEdit") FilePart minorEdit, @MultipartFormParam(value="hidden") FilePart hidden) throws ServiceException {
        boolean isMinorEdit = false;
        if (minorEdit != null && Boolean.parseBoolean(minorEdit.getValue())) {
            isMinorEdit = true;
        }
        boolean isHidden = false;
        if (hidden != null && Boolean.parseBoolean(hidden.getValue())) {
            isHidden = true;
        }
        String commentText = null;
        if (comment != null) {
            commentText = comment.getValue();
        }
        AttachmentUpload upload = this.makeAttachmentUpload(filePart, commentText, isMinorEdit, isHidden);
        try {
            com.atlassian.confluence.api.model.content.Content content = this.attachmentService.updateData(attachmentId, upload);
            return content;
        }
        finally {
            upload.getFile().delete();
        }
    }

    @Operation(description="Move an attachment to a different content entity object. \n\n**When moving the attachment**, the name of the attachment can be updated as well. \n\nIn order to protect against XSRF attacks, because this method accepts multipart/form-data, it has XSRF protection on it. This means you must submit a header of `X-Atlassian-Token: nocheck` with the request, otherwise it will be blocked. \n\nA simple example to move an attachment with id \"456\" in a container with id \"123\" to a container with \"789\": \n\n`curl -D- -u admin:admin -X POST -H \"X-Atlassian-Token: nocheck\" \"http://myhost/rest/api/content/123/child/attachment/456/move?newContentId=789\"` \n\nAn example to move the same file, while also renaming it to \"my-new-name\": \n\n`curl -D- -u admin:admin -X POST -H \"X-Atlassian-Token: nocheck\" \"http://myhost/rest/api/content/123/child/attachment/456/move?newContentId=789&newName=my-new-name\"` \n\nThis can also be used to only rename an attachment: \n\n`curl -D- -u admin:admin -X POST -H \"X-Atlassian-Token: nocheck\" \"http://myhost/rest/api/content/123/child/attachment/456/move?newContentId=123&newName=my-new-name\"`", summary="Move attachment")
    @Parameters(value={@Parameter(name="id", description="The id of the content the attachment is on.", in=ParameterIn.PATH), @Parameter(name="attachmentId", description="the id of the attachment to upload the new file for.", in=ParameterIn.PATH), @Parameter(name="file", description="the file to be uploaded."), @Parameter(name="comment", description="the comment to associate with the attachment - may be a blank string."), @Parameter(name="minorEdit", description="(optional) form parameter indicating whether the attachment should be a minorEdit. If minorEdit is set to true, no notification email will be generated for that attachment."), @Parameter(name="hidden", description="(optional) form parameter indicating whether the attachment should be hidden.If hidden is set to true, no notification email or activity stream will be generated for that attachment.")})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the operation is successful.", responseCode=204), @ResponseDoc(documentation=" Returned if no attachment is found for the attachmentId.", responseCode=404, restError=true), @ResponseDoc(documentation=" Returned if the attachment id is invalid.", responseCode=400, restError=true)})
    @POST
    @Path(value="/{attachmentId}/move")
    @ScopesAllowed(requiredScope={"WRITE"})
    public void move(@PathParam(value="id") ContentId contentId, @PathParam(value="attachmentId") ContentId attachmentId, @QueryParam(value="newContentId") ContentId newContentId, @QueryParam(value="newName") String newName) throws ServiceException {
        this.attachmentService.moveAttachment(attachmentId, contentId, newContentId, newName);
    }

    @Operation(description="This method will delete the attachment identified by attachmentId.\n\nIt returns a boolean response indicating whether the operation was successful or not. If the specified attachment or version does not exist, or if the user does not have permission to remove the attachment, appropriate exceptions are thrown and mapped to their corresponding HTTP responses.", summary="Remove attachment")
    @Parameters(value={@Parameter(name="id", description="The id of the content the attachment is on.", in=ParameterIn.PATH), @Parameter(name="attachmentId", description="the id of the attachment to be removed.", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns no response if the specified attachment is successfully removed.", responseCode=204), @ResponseDoc(documentation=" Returned if the specified attachment does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if the user does not have permission to remove the attachment.", responseCode=400, restError=true)})
    @DELETE
    @Path(value="/{attachmentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response removeAttachment(@PathParam(value="id") ContentId contentId, @PathParam(value="attachmentId") ContentId attachmentId) throws ServiceException {
        this.attachmentService.removeAttachment(contentId, attachmentId);
        return Response.noContent().build();
    }

    @Operation(description="This method will delete the specified version of an attachment identified by attachmentId and version.\n\nIf the operation is successful, it returns a response indicating that no content is returned. If the specified attachment or version does not exist, or if the user does not have permission to remove the attachment, appropriate exceptions are thrown and mapped to their corresponding HTTP responses.", summary="Remove attachment version")
    @Parameters(value={@Parameter(name="id", description="The id of the content the attachment is on.", in=ParameterIn.PATH), @Parameter(name="attachmentId", description="The id of the attachment to be removed.", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns no content if the specified attachment version is successfully removed.", responseCode=204), @ResponseDoc(documentation="Returned if the specified attachment or version does not exist.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if the user does not have permission to remove the attachment.", responseCode=400, restError=true)})
    @DELETE
    @Path(value="/{attachmentId}/version/{version}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response removeAttachmentVersion(@PathParam(value="id") ContentId contentId, @PathParam(value="attachmentId") ContentId attachmentId, @PathParam(value="version") int version) throws ServiceException {
        this.attachmentService.removeAttachmentVersion(contentId, attachmentId, version);
        return Response.noContent().build();
    }

    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the attachments extracted text.", responseCode=200, representation=AttachmentExtractedText.class), @ResponseDoc(documentation="Returned if attachment extracted text is not available", responseCode=204), @ResponseDoc(documentation=" Returned if no attachment is found for the attachmentId.", responseCode=404, restError=true), @ResponseDoc(documentation=" Returned if the attachment id or content id is invalid.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if you don't have permission to view attachments.", responseCode=403, restError=true)})
    @GET
    @Path(value="/{attachmentId}/extractedtext")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getAttachmentExtractedText(@PathParam(value="id") ContentId contentId, @PathParam(value="attachmentId") ContentId attachmentId, @QueryParam(value="limit") long limit) throws ServiceException {
        Optional extractedText;
        long actualLimit = Math.min(limit, 0x200000L);
        if (actualLimit <= 0L) {
            actualLimit = 0x200000L;
        }
        if ((extractedText = this.attachmentExtractedTextService.extractedText(contentId, attachmentId, actualLimit)).isPresent()) {
            return Response.ok((Object)new AttachmentExtractedText((String)extractedText.get())).build();
        }
        return Response.noContent().build();
    }

    private List<AttachmentUpload> convertFilePartsToAttachmentUploads(List<FilePart> fileParts, List<FilePart> comments, List<FilePart> minorEdits, List<FilePart> hiddens) throws ServiceException {
        ArrayList<AttachmentUpload> uploads = new ArrayList<AttachmentUpload>();
        int numFiles = fileParts.size();
        for (int i = 0; i < numFiles; ++i) {
            FilePart filePart = fileParts.get(i);
            String comment = comments.isEmpty() ? null : comments.get(i).getValue();
            boolean minorEdit = !minorEdits.isEmpty() && Boolean.parseBoolean(minorEdits.get(i).getValue());
            boolean hidden = !hiddens.isEmpty() && Boolean.parseBoolean(hiddens.get(i).getValue());
            uploads.add(this.makeAttachmentUpload(filePart, comment, minorEdit, hidden));
        }
        return uploads;
    }

    private AttachmentUpload makeAttachmentUpload(FilePart filePart, String comment, boolean minorEdit, boolean hidden) throws ServiceException {
        return new AttachmentUpload(this.getFileFromFilePart(filePart), filePart.getName(), filePart.getContentType(), comment, minorEdit, hidden);
    }

    private File getFileFromFilePart(FilePart filePart) throws ServiceException {
        try {
            File file = File.createTempFile("attachment-", ".tmp");
            if (!file.delete()) {
                log.debug("Could not remove newly created temp file. Continuing");
            }
            file.deleteOnExit();
            filePart.write(file);
            return file;
        }
        catch (IOException e) {
            throw new ServiceException("Error processing FilePart: " + filePart.getName(), (Throwable)e);
        }
    }

    public static class ConfluenceAttachmentMultipartConfig
    implements MultipartConfig {
        private static SettingsService settingsService;

        public long getMaxFileSize() {
            return settingsService.getGlobalSettings().getAttachmentMaxSizeBytes();
        }

        public long getMaxSize() {
            return this.getMaxFileSize() * 10L;
        }
    }

    private static class MockAttachmentRequest
    implements FilePart {
        @Schema(description="The name of the multipart/form-data parameter that contains attachments must be \\\"file\\\".")
        private String file;
        @Schema(description="(optional) a list of \\\"comments\\\" matching the list of attachment data.\\nIf supplied, the size of this list must match the size of the fileParts list.")
        private String comment;
        @Schema(description="(optional) form parameter indicating whether the attachments should be \\\"minorEdits\\\".If \\\"minorEdits\\\" is set to true, no notification email will be generated for that attachment.")
        private Boolean minorEdit;
        @Schema(description="(optional) form parameter indicating whether the attachments should be \\\"hidden\\\".If \\\"hidden\\\" is set to true, no notification email or activity stream will be generated for that attachment.")
        private Boolean hidden;

        private MockAttachmentRequest() {
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public Boolean getMinorEdit() {
            return this.minorEdit;
        }

        public void setMinorEdit(Boolean minorEdit) {
            this.minorEdit = minorEdit;
        }

        public Boolean getHidden() {
            return this.hidden;
        }

        public void setHidden(Boolean hidden) {
            this.hidden = hidden;
        }

        @Schema(hidden=true)
        public String getName() {
            return null;
        }

        @Schema(hidden=true)
        public String getContentType() {
            return null;
        }

        @Schema(hidden=true)
        public void write(File file) {
        }

        @Schema(hidden=true)
        public InputStream getInputStream() {
            return null;
        }

        @Schema(hidden=true)
        public String getValue() {
            return null;
        }

        @Schema(hidden=true)
        public boolean isFormField() {
            return false;
        }

        @Schema(hidden=true)
        public long getSize() {
            return 0L;
        }
    }
}

