/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.backuprestore.FileInfo;
import com.atlassian.confluence.api.model.backuprestore.JobDetails;
import com.atlassian.confluence.api.model.backuprestore.JobFilter;
import com.atlassian.confluence.api.model.backuprestore.JobOperation;
import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.atlassian.confluence.api.model.backuprestore.JobState;
import com.atlassian.confluence.api.model.backuprestore.SiteBackupJobDetails;
import com.atlassian.confluence.api.model.backuprestore.SiteBackupSettings;
import com.atlassian.confluence.api.model.backuprestore.SiteRestoreJobDetails;
import com.atlassian.confluence.api.model.backuprestore.SiteRestoreSettings;
import com.atlassian.confluence.api.model.backuprestore.SpaceBackupJobDetails;
import com.atlassian.confluence.api.model.backuprestore.SpaceBackupSettings;
import com.atlassian.confluence.api.model.backuprestore.SpaceRestoreJobDetails;
import com.atlassian.confluence.api.model.backuprestore.SpaceRestoreSettings;
import com.atlassian.confluence.api.service.backuprestore.BackupRestoreService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.multipart.FilePart;
import com.atlassian.plugins.rest.api.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/backup-restore")
@Tag(name="Backup and Restore")
public class BackupRestoreResource {
    private static final Set<String> ALLOWED_ZIP_MIME_TYPES = ImmutableSet.of((Object)"application/zip", (Object)"application/x-zip-compressed");
    private final BackupRestoreService backupRestoreService;

    @Inject
    public BackupRestoreResource(@ComponentImport BackupRestoreService backupRestoreService) {
        this.backupRestoreService = backupRestoreService;
    }

    @Operation(summary="Create space backup job", description="Creates new space backup job and adds it to the queue.")
    @RequestBody(description="Space backup settings", content={@Content(schema=@Schema(implementation=SpaceBackupSettings.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the space backup job", representation=SpaceBackupJobDetails.class), @ResponseDoc(documentation="Returned if invalid settings provided", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if user doesn't have permission to create space backups", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if backup with the same spaces selected is already in PROGRESS or QUEUED", responseCode=409, restError=true)})
    @POST
    @Path(value="/backup/space")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response createSpaceBackupJob(SpaceBackupSettings settings) {
        SpaceBackupJobDetails job = this.backupRestoreService.createSpaceBackupJob(settings);
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Create site backup job", description="Starts the new site backup job.")
    @RequestBody(description="Site backup settings", content={@Content(schema=@Schema(implementation=SiteBackupSettings.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the site backup job details.", representation=SiteBackupJobDetails.class), @ResponseDoc(documentation=" Returned if invalid settings provided", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if user doesn't have permission to create site backups", responseCode=409, restError=true)})
    @POST
    @WebSudoRequired
    @SystemAdminOnly
    @Path(value="/backup/site")
    public Response createSiteBackupJob(SiteBackupSettings settings) {
        SiteBackupJobDetails job = this.backupRestoreService.createSiteBackupJob(settings);
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Create space restore job", description="Creates new space restore job and adds it to the queue.")
    @RequestBody(description="space restore settings", content={@Content(schema=@Schema(implementation=SpaceRestoreSettings.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the space restore job.", representation=SpaceRestoreJobDetails.class), @ResponseDoc(documentation=" Returned if invalid filename provided", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if user doesn't have permission to restore spaces", responseCode=403, restError=true)})
    @POST
    @WebSudoRequired
    @SystemAdminOnly
    @Path(value="/restore/space")
    public Response createSpaceRestoreJob(SpaceRestoreSettings settings) {
        SpaceRestoreJobDetails job = this.backupRestoreService.createSpaceRestoreJob(settings);
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Create site restore job", description="Starts the new site restore job.")
    @RequestBody(description="space restore settings", content={@Content(schema=@Schema(implementation=SiteRestoreSettings.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the site restore job.", representation=SiteRestoreJobDetails.class), @ResponseDoc(documentation=" Returned if invalid filename provided", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if user doesn't have permission to restore site", responseCode=403, restError=true)})
    @POST
    @WebSudoRequired
    @SystemAdminOnly
    @Path(value="/restore/site")
    public Response createSiteRestoreJob(SiteRestoreSettings settings) {
        SiteRestoreJobDetails job = this.backupRestoreService.createSiteRestoreJob(settings);
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Create space restore job for upload backup file", description="This resource expects a multipart post. The media-type multipart/form-data is defined in RFC 1867. \n\nMost client libraries have classes that make dealing with multipart posts simple. \n\nFor instance, in Java the Apache HTTP Components library provides a MultiPartEntity that makes it simple to submit a multipart POST. \n\n In order to protect against XSRF attacks, because this method accepts multipart/form-data, it has XSRF protection on it.  This means you must submit a header of X-Atlassian-Token: nocheck with the request, otherwise it will be blocked. \n\n The name of the multipart/form-data parameter that contains attachments must be \"file\". \n\n An example to attach the file: \n\n curl -D- -u admin:admin -X POST -H \"X-Atlassian-Token: nocheck\" -F  file=@myfile.zip http://myhost/rest/api/backup-restore/restore/space/upload \n\n.")
    @RequestBody(description="backup file uploaded. Has to be a zip file.", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=ExampleMultipartFormData.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the space restore job details.", representation=SpaceRestoreJobDetails.class), @ResponseDoc(documentation=" Returned if the uploaded file is not a zip file", responseCode=400, restError=true), @ResponseDoc(documentation=" Returned if user doesn't have permission to restore space", responseCode=403, restError=true)})
    @POST
    @WebSudoRequired
    @SystemAdminOnly
    @Consumes(value={"multipart/form-data"})
    @Path(value="/restore/space/upload")
    public Response createSpaceRestoreJobForUploadedBackupFile(@MultipartFormParam(value="file") FilePart file) throws IOException {
        BackupRestoreResource.validateZipFile(file);
        SpaceRestoreSettings spaceRestoreSettings = new SpaceRestoreSettings();
        spaceRestoreSettings.setFileName(file.getName());
        SpaceRestoreJobDetails job = this.backupRestoreService.createSpaceRestoreJob(spaceRestoreSettings, file.getInputStream());
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Create site restore job for upload backup file", description="This resource expects a multipart post. The media-type multipart/form-data is defined in RFC 1867. \n\nMost client libraries have classes that make dealing with multipart posts simple. \n\nFor instance, in Java the Apache HTTP Components library provides a MultiPartEntity that makes it simple to submit a multipart POST. \n\n In order to protect against XSRF attacks, because this method accepts multipart/form-data, it has XSRF protection on it.  This means you must submit a header of X-Atlassian-Token: nocheck with the request, otherwise it will be blocked. \n\n The name of the multipart/form-data parameter that contains attachments must be \"file\". \n\n An example to attach the file: \n\n curl -D- -u admin:admin -X POST -H \"X-Atlassian-Token: nocheck\" -F  file=@myfile.zip http://myhost/rest/api/backup-restore/restore/space/upload \n\n.")
    @RequestBody(description="Backup file to be uploaded. Has to be a zip file.", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=ExampleMultipartFormData.class))})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the site restore job details.", representation=SiteRestoreJobDetails.class), @ResponseDoc(documentation=" Returned if the uploaded file is not a zip file", responseCode=400, restError=true), @ResponseDoc(documentation=" Returned if user doesn't have permission to restore space", responseCode=403, restError=true)})
    @POST
    @WebSudoRequired
    @SystemAdminOnly
    @Consumes(value={"multipart/form-data"})
    @Path(value="/restore/site/upload")
    public Response createSiteRestoreJobForUploadedBackupFile(@MultipartFormParam(value="file") FilePart file) throws IOException {
        BackupRestoreResource.validateZipFile(file);
        SiteRestoreSettings siteRestoreSettings = new SiteRestoreSettings();
        siteRestoreSettings.setFileName(file.getName());
        SiteRestoreJobDetails job = this.backupRestoreService.createSiteRestoreJob(siteRestoreSettings, file.getInputStream());
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Get job by ID", description="Get job by id. The user must be a sysadmin or the owner of the job.")
    @Parameter(name="jobId", description="id of the backup/restore job", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the backup/restore job", representation=JobDetails.class), @ResponseDoc(documentation=" Returned if jobId is null", responseCode=400, restError=true), @ResponseDoc(documentation=" Returned if job not found or user doesn't have permission to see it", responseCode=403, restError=true)})
    @GET
    @Path(value="/jobs/{jobId}")
    @ScopesAllowed(requiredScope={"READ"})
    public Response getJob(@PathParam(value="jobId") Long jobId) {
        if (jobId == null) {
            throw new BadRequestException("jodId couldn't be null");
        }
        JobDetails job = this.backupRestoreService.getJob(jobId.longValue());
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Find jobs by filters", description="Returns jobs based on the filters provided. The user must have permission to see the jobs.")
    @Parameters(value={@Parameter(name="limit", description="amount of jobs that should be returned", in=ParameterIn.QUERY), @Parameter(name="fromDate", description="minimum job creation date. Supported date format is `yyyy-MM-ddTHH:mm:ss.SSSZ`", in=ParameterIn.QUERY), @Parameter(name="toDate", description="maximum job create date. Supported date format is `yyyy-MM-ddTHH:mm:ss.SSSZ`", in=ParameterIn.QUERY), @Parameter(name="jobScope", description="scope of the job. Acceptable values: \"SPACE\" and \"SITE\" ", in=ParameterIn.QUERY), @Parameter(name="jobOperation", description="job operation. Acceptable values: \"BACKUP\" and \"RESTORE\"", in=ParameterIn.QUERY), @Parameter(name="jobStates", description="list of job states. Acceptable values: \"QUEUED\", \"PROCESSING\", \"FINISHED\", \"CANCELLING\", \"CANCELLED\", \"FAILED\"", in=ParameterIn.QUERY), @Parameter(name="spaceKey", description="the key of the Space the User is attempting to view.", in=ParameterIn.QUERY), @Parameter(name="owner", description="userName of user who had created a job.", in=ParameterIn.QUERY)})
    @ApiResponse(responseCode="200", description="Returns the List of backup/restore jobs visible to user based on the filter provided and the user's permissions.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=JobDetails.class)))})
    @ResponseDoc(documentation="Returned if invalid filter parameters were passed", responseCode=400, restError=true)
    @GET
    @Path(value="/jobs")
    @ScopesAllowed(requiredScope={"READ"})
    public Response findJobs(@QueryParam(value="limit") @DefaultValue(value="25") Integer limit, @QueryParam(value="fromDate") String fromDate, @QueryParam(value="toDate") String toDate, @QueryParam(value="jobScope") JobScope jobScope, @QueryParam(value="jobOperation") JobOperation jobOperation, @QueryParam(value="jobStates") List<JobState> jobStates, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="owner") String owner) {
        JobFilter jobFilter;
        try {
            JobFilter.Builder builder = JobFilter.builder();
            builder.setJobScope(jobScope);
            builder.setJobOperation(jobOperation);
            jobStates.forEach(arg_0 -> ((JobFilter.Builder)builder).addJobState(arg_0));
            builder.setOwner(owner);
            builder.setFromDate(BackupRestoreResource.convertDate(fromDate));
            builder.setToDate(BackupRestoreResource.convertDate(toDate));
            builder.setSpaceKey(spaceKey);
            builder.setLimit(limit.intValue());
            jobFilter = builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException((Throwable)e);
        }
        List job = this.backupRestoreService.findJobs(jobFilter);
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Get files in restore directory", description="returns list of information on files in conf-home/restore/(jobScope).")
    @Parameter(name="jobScope", description="name of type of restore job (SITE or SPACE or null), if null, all backup files are listed", in=ParameterIn.QUERY)
    @ApiResponse(responseCode="200", description="Returns a list of FileInfo objects, containing fileName, fileCreationTime, fileSize, and jobScope.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileInfo.class)))})
    @ResponseDoc(documentation="Returned if user is not a system administrator", responseCode=400, restError=true)
    @GET
    @WebSudoRequired
    @SystemAdminOnly
    @Path(value="/restore/files")
    public Response getFiles(@QueryParam(value="jobScope") JobScope jobScope) {
        List fileInfoList = this.backupRestoreService.getFiles(jobScope);
        return Response.ok((Object)fileInfoList).build();
    }

    @Operation(summary="Cancel job", description="Cancels the job. If the job is already cancelled or failed, the method will do nothing.")
    @Parameter(name="jobId", description="id of the backup/restore job", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a JSON representation of the cancelled job.", representation=JobDetails.class), @ResponseDoc(documentation="Returned if job not found or user doesn't have permission to cancel it", responseCode=404, restError=true)})
    @PUT
    @Path(value="/jobs/{jobId}/cancel")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response cancelJob(@PathParam(value="jobId") Long jobId) {
        if (jobId == null) {
            throw new BadRequestException("jodId couldn't be null");
        }
        JobDetails job = this.backupRestoreService.cancelJob(jobId.longValue());
        return Response.ok((Object)job).build();
    }

    @Operation(summary="Download backup file", description="Downloads the backup file for the given job. Requires site admin or space export permissions for all spaces included in the backup job.")
    @Parameter(name="jobId", description="id of the backup/restore job", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns a data stream of the backup file content.", representation=JobDetails.class), @ResponseDoc(documentation="Returned if job not found or user doesn't have permissions for the job or the file is missing", responseCode=404, restError=true)})
    @GET
    @Path(value="/jobs/{jobId}/download")
    @ScopesAllowed(requiredScope={"READ"})
    public Response downloadBackupFile(@PathParam(value="jobId") Long jobId) {
        if (jobId == null) {
            throw new BadRequestException("jodId couldn't be null");
        }
        try {
            File backupFile = this.backupRestoreService.getBackupFile(jobId);
            StreamingOutput streamingOutput = outputStream -> {
                try (FileInputStream inputStream = new FileInputStream(backupFile);){
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                }
            };
            return Response.ok((Object)streamingOutput, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", (Object)("attachment; filename=\"" + backupFile.getName() + "\"")).header("Content-Length", (Object)Long.toString(backupFile.length())).build();
        }
        catch (NotFoundException e) {
            throw new NotFoundException(String.format("Job, file or permissions missing for jobId %d", jobId));
        }
    }

    @Operation(summary="Cancel all queued jobs", description="Cancels all queued jobs. Does not affect jobs that are being processed at the moment.")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returns the number of cancelled jobs. If no jobs were cancelled, 0 is returned.\nExample response: `1`"), @ResponseDoc(documentation="Returned if user doesn't have permission to cancel jobs", responseCode=403, restError=true)})
    @PUT
    @WebSudoRequired
    @SystemAdminOnly
    @Path(value="/jobs/clear-queue")
    public Response cancelAllQueuedJobs() {
        int cancelledJobsCount = this.backupRestoreService.cancelAllQueuedJobs();
        return Response.ok((Object)cancelledJobsCount).build();
    }

    private static Instant convertDate(String stringDate) {
        if (StringUtils.isEmpty((CharSequence)stringDate)) {
            return null;
        }
        try {
            return Instant.parse(stringDate);
        }
        catch (DateTimeParseException e) {
            throw new BadRequestException(String.format("Date %s is in invalid format. Supported date format is `yyyy-MM-ddTHH:mm:ss.SSSZ`", stringDate));
        }
    }

    private static void validateZipFile(FilePart file) {
        if (!ALLOWED_ZIP_MIME_TYPES.contains(file.getContentType())) {
            throw new BadRequestException("The uploaded file should be a valid zip file.");
        }
    }

    private static class ExampleMultipartFormData
    implements FilePart {
        @Schema(description="backup file uploaded. Has to be a zip file.")
        private String file;

        private ExampleMultipartFormData() {
        }

        public String getFile() {
            return this.file;
        }

        @Schema(hidden=true)
        public String getName() {
            throw new NotFoundException("This method should not be invoked");
        }

        @Schema(hidden=true)
        public String getContentType() {
            throw new NotFoundException("This method should not be invoked");
        }

        public void write(File file) {
            throw new NotFoundException("This method should not be invoked");
        }

        @Schema(hidden=true)
        public InputStream getInputStream() {
            throw new NotFoundException("This method should not be invoked");
        }

        @Schema(hidden=true)
        public String getValue() {
            throw new NotFoundException("This method should not be invoked");
        }

        @Schema(hidden=true)
        public boolean isFormField() {
            throw new NotFoundException("This method should not be invoked");
        }

        @Schema(hidden=true)
        public long getSize() {
            throw new NotFoundException("This method should not be invoked");
        }
    }
}

