/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.content.CategoryService;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/space/{spaceKey}/category")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@SendsAnalytics
@Tag(name="Category")
public class CategoryResource {
    private final CategoryService categoryService;

    @Inject
    public CategoryResource(@ComponentImport CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    @Operation(summary="Add a category to a space", description="Adds a category the description of a given {@link Space} identified by spaceKey.\n\nExample request URI to add space category 'testCategory' to space with space key TEST:\n\n`https://example.com/confluence/rest/api/space/TEST/category/testCategory`")
    @Parameters(value={@Parameter(name="spaceKey", description="a string containing the key of the space", in=ParameterIn.PATH), @Parameter(name="labelName", description="the name of the label to be added (do not include any prefix, team: prefix assumed)", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="a request has been successfully completed. A new label has been added or it already exist. No content is returned.", responseCode=204), @ResponseDoc(documentation="Returned if the calling user is not authenticated.", responseCode=401, restError=true), @ResponseDoc(documentation="If the calling user does not have permission to add any label to the given space.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is no space with the given spaceKey.", responseCode=404, restError=true)})
    @POST
    @Path(value="/{labelName}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response add(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="labelName") String labelName) {
        this.categoryService.addCategory(spaceKey, labelName);
        return Response.noContent().build();
    }

    @Operation(summary="Remove a category from a space", description="Removes a category from a space, identified by spaceKey.\n\nExample request URI:\n`https://example.com/confluence/rest/api/space/TEST/category/example-category`")
    @Parameters(value={@Parameter(name="spaceKey", description="The key of the space to remove the category from", required=true, in=ParameterIn.PATH), @Parameter(name="categoryName", description="The name of the category to remove", required=true, in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if the category is removed successfully.", responseCode=204), @ResponseDoc(documentation="Returned if the calling user is not authenticated.", responseCode=401), @ResponseDoc(documentation="Returned if the calling user does not have permission to edit the Space.", responseCode=403), @ResponseDoc(documentation="Returned if there is no space with the given key", responseCode=404)})
    @DELETE
    @Path(value="/{categoryName}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response removeCategory(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="categoryName") String categoryName) {
        this.categoryService.removeCategory(spaceKey, categoryName);
        return Response.noContent().build();
    }
}

