/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import java.util.Set;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/child")
@Tag(name="Child Content")
@PathParamDoc(name="id", documentation="The id of the content to retrieve children for")
public class ChildContentResource {
    private final ChildContentService childContentService;

    @Inject
    public ChildContentResource(@ComponentImport ChildContentService childContentService) {
        this.childContentService = childContentService;
    }

    @Operation(summary="Get children of content", description="Returns a map of the direct children of a piece of Content. Content can have multiple types of children. For example, a Page can have children that are also Pages, but it can also have Comments and Attachments. \n\nThe types of the children returned is specified by the `expand` query parameter in the request. This parameter can include expands for multiple child types. If no types are included in the `expand` parameter, the map returned will just list the child types that are available to be expanded for the content referenced by the `id` path parameter.")
    @Parameters(value={@Parameter(name="expand", description="a comma separated list of properties to expand on the children", in=ParameterIn.QUERY), @Parameter(name="parentVersion", description="an int representing the version of the content to retrieve children for"), @Parameter(name="start", description="the index of the first item within the result set that should be returned", in=ParameterIn.QUERY), @Parameter(name="limit", description="how many items should be returned after the start index", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Returned if the children are successfully retrieved. The response body contains a JSON map representing multiple ordered collections of content children, keyed by content type.", representation=Content.class, paged=true), @ResponseDoc(documentation=" Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Map<ContentType, PageResponse<Content>> children(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="parentVersion") @DefaultValue(value="0") Integer parentVersion, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @Context UriInfo uriInfo) throws ServiceException {
        Expansions expansions = ExpansionsParser.parseAsExpansions((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return this.childContentService.findContent(contentId, expansions.toArray()).withParentVersion(parentVersion.intValue()).fetchMappedByType((PageRequest)pageRequest);
    }

    @Operation(summary="Get children of content by type", description="Returns the direct children of a piece of Content, limited to a single child type.The types of the children returned is specified by the \"type\" path parameter in the request.")
    @Parameters(value={@Parameter(name="type", description="a  content type to filter children on.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the children", in=ParameterIn.QUERY), @Parameter(name="parentVersion", description="an int representing the version of the content to retrieve children for"), @Parameter(name="start", description="the index of the first item within the result set that should be returned", in=ParameterIn.QUERY), @Parameter(name="limit", description="how many items should be returned after the start index", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a JSON map representing multiple ordered collections of content children, keyed by content type", responseCode=200, representation=Content.class, paged=true), @ResponseDoc(documentation=" Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{type}")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Content> childrenOfType(@PathParam(value="id") ContentId contentId, @PathParam(value="type") ContentType type, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="parentVersion") @DefaultValue(value="0") Integer parentVersion, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @Context UriInfo uriInfo) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse children = this.childContentService.findContent(contentId, expansions).withParentVersion(parentVersion.intValue()).fetchMany(type, (PageRequest)pageRequest);
        return RestList.createRestList((PageRequest)pageRequest, (PageResponse)children);
    }

    @Operation(summary="Get comments of content", description="Returns the comments of a piece of Content. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content/1234/child/comment`\n- `http://example.com/confluence/rest/api/content/1234/child/comment?expand=body.view`\n- `http://example.com/confluence/rest/api/content/1234/child/comment?start=20&limit=10`\n- `http://example.com/confluence/rest/api/content/1234/child/comment?location=footer&location=inline&location=resolved`\n- `http://example.com/confluence/rest/api/content/1234/child/comment?expand=extensions.inlineProperties,extensions.resolution`")
    @Parameters(value={@Parameter(name="expand", description="a comma separated list of properties to expand on the children", in=ParameterIn.QUERY), @Parameter(name="parentVersion", description="an int representing the version of the content to retrieve children for"), @Parameter(name="start", description="the index of the first item within the result set that should be returned", in=ParameterIn.QUERY), @Parameter(name="limit", description="how many items should be returned after the start index", in=ParameterIn.QUERY), @Parameter(name="location", description="(optional, default: \"\" means all) the location of the comments. Possible values are: \"inline\", \"footer\", \"resolved\".\nYou can define multiple location params. The results will be the comments matched by any location.", in=ParameterIn.QUERY), @Parameter(name="depth", description="(optional, default: \"\") the depth of the comments. Possible values are: \"\" (ROOT only), \"all\"", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a JSON map representing multiple ordered collections of content children, keyed by content type", responseCode=200, representation=Content.class, paged=true), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to\nview the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="/comment")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Content> commentsOfContent(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="parentVersion") @DefaultValue(value="0") Integer parentVersion, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="location") Set<String> location, @QueryParam(value="depth") @DefaultValue(value="") String depth, @Context UriInfo uriInfo) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Depth fetchDepth = depth.equalsIgnoreCase("all") ? Depth.ALL : Depth.ROOT;
        PageResponse children = this.childContentService.findContent(contentId, expansions).withDepth(fetchDepth).withLocation(location).withParentVersion(parentVersion.intValue()).fetchMany(ContentType.COMMENT, (PageRequest)pageRequest);
        return RestList.createRestList((PageRequest)pageRequest, (PageResponse)children);
    }
}

