/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.system.NodeStatus;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.system.ClusterService;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/cluster")
@Tag(name="Cluster information")
@WebSudoRequired
@SystemAdminOnly
public class ClusterResource {
    private final ClusterService clusterService;

    @Inject
    public ClusterResource(@ComponentImport ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    @Operation(summary="Get node statuses in a cluster", description="Returns a paginated list of information about each node in a cluster. Example request URI(s):\n- `https://example.com/confluence/rest/api/cluster/nodes`\n- `https://example.com/confluence/rest/api/cluster/nodes?start=0&limit=10`\n")
    @Parameters(value={@Parameter(name="start", description="The start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="The limit of the number of node statuses to return, this may be restricted by fixed system limit.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Return a list of nodes and their status.", responseCode=200, representation=NodeStatus.class, paged=true), @ResponseDoc(documentation="Returned if user does not have permission to view cluster information.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if user has not been authenticated.", responseCode=401, restError=true)})
    @GET
    @Path(value="/nodes")
    @PublicApi
    public RestList<NodeStatus> getClusterNodeStatuses(@QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit, @Context UriInfo uriInfo) throws ServiceException {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse clusterNodeStatuses = this.clusterService.getClusterNodeStatuses((PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)clusterNodeStatuses).pageRequest((PageRequest)pageRequest.copyWithLimits(clusterNodeStatuses)).build();
    }
}

