/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentBlueprintService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;

@AnonymousSiteAccess
@LimitRequestSize(value=0x500000L)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/blueprint")
@Tag(name="Content Blueprint")
@PublicApi
public class ContentBlueprintResource {
    private final ContentBlueprintService contentBlueprintService;

    @Inject
    public ContentBlueprintResource(ContentBlueprintService contentBlueprintService) {
        this.contentBlueprintService = contentBlueprintService;
    }

    @Operation(summary="Publish legacy draft", description="Publishes a legacy draft of a Content created from a ContentBlueprint.")
    @Parameters(value={@Parameter(name="draftId", description="the id of the draft", in=ParameterIn.PATH), @Parameter(name="status", description="only support 'draft' status for now.", in=ParameterIn.QUERY), @Parameter(name="expand", description="A comma separated list of properties to expand on the content. Default value: <code>body.storage,history,space,version,ancestors</code>", in=ParameterIn.QUERY)})
    @RequestBody(description="The content to be created, where the status of the included content is \"current\",\nand the content has an ID (which will be the draft ID)", content={@io.swagger.v3.oas.annotations.media.Content(schema=@Schema(implementation=Content.class))})
    @ResponseDoc(documentation="returns a JSON representation of the content", responseCode=200, representation=Content.class)
    @POST
    @Path(value="/instance/{draftId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Content publishLegacyDraft(@PathParam(value="draftId") ContentId draftId, Content content, @QueryParam(value="status") @DefaultValue(value="draft") ContentStatus status, @QueryParam(value="expand") @DefaultValue(value="body.storage,history,space,version,ancestors") String expand) throws ServiceException {
        return this.publish(draftId, content, status, expand);
    }

    @Operation(summary="Publish shared draft", description="Publishes a shared draft of a Content created from a ContentBlueprint.")
    @Parameters(value={@Parameter(name="draftId", description="the id of the draft", in=ParameterIn.PATH), @Parameter(name="status", description="only support 'draft' status for now.", in=ParameterIn.QUERY), @Parameter(name="expand", description="A comma separated list of properties to expand on the content. Default value: <code>body.storage,history,space,version,ancestors</code>", in=ParameterIn.QUERY)})
    @RequestBody(description="he content to be created, where the status of the included content is \"current\",\nand the content has an ID (which will be the draft ID)", content={@io.swagger.v3.oas.annotations.media.Content(schema=@Schema(implementation=Content.class))})
    @ResponseDoc(documentation="returns a JSON representation of the content", responseCode=200, representation=Content.class)
    @PUT
    @Path(value="/instance/{draftId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Content publishSharedDraft(@PathParam(value="draftId") ContentId draftId, Content content, @QueryParam(value="status") @DefaultValue(value="draft") ContentStatus status, @QueryParam(value="expand") @DefaultValue(value="body.storage,history,space,version,ancestors") String expand) throws ServiceException {
        return this.publish(draftId, content, status, expand);
    }

    private Content publish(ContentId draftId, Content content, ContentStatus status, String expand) {
        if (!status.equals((Object)ContentStatus.DRAFT)) {
            throw new NotImplementedServiceException("Received status '" + String.valueOf(status) + "' but only 'draft' status is currently supported");
        }
        ContentId idInObject = content.getId();
        if (idInObject == null) {
            content = Content.builder((Content)content).id(draftId).build();
        } else if (!idInObject.equals((Object)draftId)) {
            throw new BadRequestException("Draft ID doesn't match content ID.");
        }
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.contentBlueprintService.publishInstance(content, expansions);
    }
}

