/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.service.content.ContentBodyConversionService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/contentbody/convert/{to}")
@LimitRequestSize(value=0x500000L)
@Tag(name="Content Body")
public class ContentBodyResource {
    private final ContentBodyConversionService service;

    @Inject
    public ContentBodyResource(@ComponentImport ContentBodyConversionService service) {
        this.service = service;
    }

    @Operation(summary="Convert body representation", description="Converts between content body representations. Not all representations can be converted to/from other formats. Supported conversions: \n\n- `storage -> view,export_view,styled_view,editor`\n- `editor -> storage`\n- `view -> None`\n- `export_view -> None`\n- `styled_view -> None`\n\nExample request URI(s):\n\n- `http://example.com/confluence/rest/api/contentbody/convert/view`")
    @Parameters(value={@Parameter(name="to", description="the representation to convert to.", in=ParameterIn.PATH), @Parameter(name="expand", description="A comma separated list of properties to expand on the content. Default value: <code>body.storage,history,space,version,ancestors</code>", in=ParameterIn.QUERY)})
    @RequestBody(description="the body to convert from", content={@Content(schema=@Schema(implementation=ContentBody.class))})
    @ResponseDoc(documentation="returns the converted body", responseCode=200, representation=ContentBody.class)
    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public ContentBody convert(ContentBody body, @PathParam(value="to") ContentRepresentation toRepresentation, @QueryParam(value="expand") @DefaultValue(value="") String expand) throws ServiceException {
        return this.service.convert(body, toRepresentation, ExpansionsParser.parse((String)expand));
    }
}

