/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ContentLabelService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/label")
@Tag(name="Content Labels")
@PathParamDoc(name="id", documentation="the id of the content to get the labels for")
public class ContentLabelsResource {
    private static final String DEFAULT_LIMIT = "200";
    private final ContentLabelService contentLabelService;
    private final ObjectMapper mapper;

    @Inject
    public ContentLabelsResource(@ComponentImport ContentLabelService contentLabelService, ObjectMapperProvider objectMapperProvider) {
        this.contentLabelService = contentLabelService;
        this.mapper = objectMapperProvider.getObjectMapper();
    }

    @Operation(summary="Get labels", description="Returns the list of labels on a piece of Content. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content/1234/label`\n- `http://example.com/confluence/rest/api/content/1234/label?prefix=global&start=0&limit=200`")
    @Parameters(value={@Parameter(name="prefix", description="the prefixes to filter the labels with.", in=ParameterIn.QUERY), @Parameter(name="start", description="he start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the existing labels on the content with the given id", paged=true, representation=Label.class, responseCode=200), @ResponseDoc(documentation=" Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public PageResponse<Label> labels(@PathParam(value="id") ContentId contentId, @QueryParam(value="prefix") List<String> prefixes, @QueryParam(value="start") int offset, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) throws ServiceException {
        Collection<Label.Prefix> requestPrefixes = this.convertLabelPrefixStrings(prefixes);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), offset, limit);
        PageResponse labels = this.contentLabelService.getLabels(contentId, requestPrefixes, (PageRequest)pageRequest);
        return RestList.createRestList((PageRequest)pageRequest.copyWithLimits(labels), (PageResponse)labels);
    }

    @Operation(description="Adds a list of labels to the specified content. The body is the json representation of the list.", summary="Add Labels")
    @RequestBody(description="a single label object or a list of labels to add", content={@Content(schema=@Schema(implementation=Label.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the existing and added labels on the content with the given id, or a 404 NOT FOUND if there is no content with the given id or if the user is not permitted.  An empty list will be returned if there are no labels on the given content", paged=true, representation=Label.class, responseCode=200), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public PageResponse<Label> addLabels(@PathParam(value="id") ContentId contentId, String labels) throws ServiceException {
        return this.contentLabelService.addLabels(contentId, this.deserializeLabels(labels));
    }

    @Operation(summary="Delete label", description="Deletes a labels to the specified content. The body is the json representation of the list. When calling this method through REST the label parameter doesn't accept `/` characters in label names, because of security constraints. For this case please use the query parameter version of this method (`/content/{id}/label?name={label}`)")
    @Parameter(name="label", description="the name of the label to be removed from the content", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="returns no response on successful delete", responseCode=204), @ResponseDoc(documentation="Returned if content or label doesn't exist, or calling user doesn't have view permission to the content.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if trying to delete a label with \"/\" in the name.permission to the content.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if user has view permission, but no edit permission to the content.permission to the content.", responseCode=403, restError=true)})
    @DELETE
    @Path(value="/{label}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response deleteLabel(@PathParam(value="id") ContentId contentId, @PathParam(value="label") String label) throws ServiceException {
        this.contentLabelService.removeLabel(contentId, Label.builder((String)label).build());
        return Response.noContent().build();
    }

    @Operation(description="Deletes a labels to the specified content.", summary="Delete label with query param")
    @Parameter(name="name", description="the name of the label to be removed from the content", in=ParameterIn.QUERY)
    @ApiResponse(responseCode="204", description="returns no response on successful delete")
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if content or label doesn't exist, or calling user doesn't have view permission to the content.permission to the content.", responseCode=404, restError=true), @ResponseDoc(documentation=" Returned if user has view permission, but no edit permission to the content.permission to the content.", responseCode=403, restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response deleteLabelWithQueryParam(@PathParam(value="id") ContentId contentId, @QueryParam(value="name") String label) throws ServiceException {
        return this.deleteLabel(contentId, label);
    }

    private List<Label> deserializeLabels(String labelsJson) throws ServiceException {
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        try {
            return (List)this.mapper.readValue(labelsJson, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, Label.class));
        }
        catch (IOException ex) {
            throw new BadRequestException("Could not parse Labels from " + labelsJson, (Throwable)ex);
        }
    }

    private Collection<Label.Prefix> convertLabelPrefixStrings(List<String> prefixes) throws ServiceException {
        if (prefixes == null || prefixes.isEmpty()) {
            return ImmutableList.copyOf((Object[])Label.Prefix.values());
        }
        try {
            return ImmutableList.copyOf((Iterable)Iterables.transform(prefixes, Label.Prefix::valueOf));
        }
        catch (Exception ex) {
            throw new BadRequestException("Could not convert label prefixes :" + String.valueOf(prefixes), (Throwable)ex);
        }
    }
}

