/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.ContentSelector;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.google.common.base.Strings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.Optional;

@AnonymousSiteAccess
@LimitRequestSize
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/property")
@PathParamDoc(name="id", documentation="the id of the content")
@Tag(name="Content Property")
@PublicApi
public class ContentPropertyResource {
    private static final String DEFAULT_LIMIT = "10";
    private final ContentPropertyService service;

    @Inject
    public ContentPropertyResource(@ComponentImport ContentPropertyService service) {
        this.service = service;
    }

    @Operation(summary="Create a content property", description="Creates a new content property.")
    @RequestBody(description="content property to be created.", content={@Content(schema=@Schema(implementation=JsonContentProperty.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the content property.", representation=JsonContentProperty.class, responseCode=200), @ResponseDoc(documentation=" Returned if the given property has a different ContentId to the one in the path, or\n\n if the content already has a value with the given key, or the value is missing, or the value is too long.", responseCode=400, restError=true), @ResponseDoc(documentation=" Returned if the user does not have permission to edit the content with the given ContentId.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if the value is too long.", responseCode=413, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    public JsonContentProperty create(@PathParam(value="id") ContentId contentId, JsonContentProperty newProperty) throws ServiceException {
        newProperty = this.validateOrUpdateContentRef(contentId, newProperty);
        return this.service.create(newProperty);
    }

    @POST
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public JsonContentProperty create(@PathParam(value="id") ContentId contentId, @PathParam(value="key") String key, JsonContentProperty newProperty) throws ServiceException {
        newProperty = this.validateOrUpdateContentRef(contentId, newProperty);
        newProperty = this.validateOrUpdatePropertyKey(key, newProperty);
        return this.service.create(newProperty);
    }

    @Operation(summary="Find all content properties", description="Returns a paginated list of content properties. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content/1234/property?expand=content,version`")
    @Parameters(value={@Parameter(name="expand", description="a comma separated list of properties to expand on the content properties. Default value: <code>version</code>.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the content properties, or a 404 NOT FOUND if there is no content with the given id or if the user is not permitted..", representation=JsonContentProperty.class, paged=true, responseCode=200), @ResponseDoc(documentation=" Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<JsonContentProperty> findAll(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @Context UriInfo uriInfo) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse response = this.service.find(expansions).withContentId(contentId).fetchMany((PageRequest)pageRequest);
        return RestList.createRestList((PageRequest)pageRequest, (PageResponse)response);
    }

    @Operation(summary="Find content property by key", description="Returns a content property. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content/1234/property/example-property-key?expand=content,version`")
    @Parameters(value={@Parameter(name="expand", description="a comma separated list of properties to expand on the content properties. Default value: <code>version</code>.", in=ParameterIn.QUERY), @Parameter(name="key", description="the key of the content property. Required.", in=ParameterIn.PATH), @Parameter(name="limit", description="the limit of the number of labels to return, this may be restricted by fixed system limits", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the content property.", representation=JsonContentProperty.class, responseCode=200), @ResponseDoc(documentation="Returned if there is no content with the given id, or no property with the given key, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"READ"})
    public JsonContentProperty findByKey(@PathParam(value="id") ContentId contentId, @PathParam(value="key") String key, @QueryParam(value="expand") String expand) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        Optional contentProperty = this.service.find(expansions).withContentId(contentId).withPropertyKey(key).fetch();
        return (JsonContentProperty)contentProperty.orElseThrow(ServiceExceptionSupplier.notFound((String)("No content property found with key: " + key)));
    }

    @Operation(summary="Update content property", description="Updates a content property. The body contains the representation of the content property. Must include the property id, and the new version number. Attempts to create a new content property if the given version number is `1`")
    @Parameters(value={@Parameter(name="expand", description="a comma separated list of properties to expand on the content properties. Default value: <code>version</code>.", in=ParameterIn.QUERY), @Parameter(name="key", description="the key of the content property. Required.", in=ParameterIn.PATH)})
    @RequestBody(description="the content property being updated", content={@Content(schema=@Schema(implementation=JsonContentProperty.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="returns  a JSON representation of the content property, or a 404 NOT FOUND if there is no content with the given id, or no property with the given key, or if the user is not permitted.", representation=JsonContentProperty.class, responseCode=200), @ResponseDoc(documentation="Returned if the given property has a different ContentId to the one in the path, or if the property has a different key to the one in the path, or the value is missing, or the value is too long.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the user does not have permission to edit the content with the given ContentId.", responseCode=403, restError=true), @ResponseDoc(documentation="eturned if there is no content with the given id, or no property with the given key, or if the calling user does not have permission to view the content.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if the given version is does not match the expected target version of the updated property.", responseCode=409, restError=true), @ResponseDoc(documentation="Returned if the value is too long.", responseCode=413, restError=true)})
    @PUT
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public JsonContentProperty update(@PathParam(value="id") ContentId contentId, @PathParam(value="key") String key, JsonContentProperty property) throws IOException, ServiceException {
        property = this.validateOrUpdateContentRef(contentId, property);
        Version version = (property = this.validateOrUpdatePropertyKey(key, property)).getVersion();
        if (version != null && version.getNumber() == 1) {
            return this.service.create(property);
        }
        return this.service.update(property);
    }

    @Operation(summary="Delete content property", description="Deletes a content property.")
    @Parameter(name="key", description="the key of the content property. Required.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if successfully deleted.", responseCode=204), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="{key}")
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response delete(@PathParam(value="id") ContentId contentId, @PathParam(value="key") String key) throws ServiceException {
        JsonContentProperty property = JsonContentProperty.builder().content(com.atlassian.confluence.api.model.content.Content.buildReference((ContentSelector)ContentSelector.builder().id(contentId).build())).key(key).build();
        this.service.delete(property);
        return Response.noContent().build();
    }

    private JsonContentProperty validateOrUpdatePropertyKey(String key, JsonContentProperty property) {
        if (Strings.isNullOrEmpty((String)property.getKey())) {
            property = JsonContentProperty.builder((JsonContentProperty)property).key(key).build();
        } else if (!key.equals(property.getKey())) {
            throw new BadRequestException("Path/value mismatch on key");
        }
        return property;
    }

    private JsonContentProperty validateOrUpdateContentRef(ContentId contentId, JsonContentProperty property) {
        if (!property.getContentRef().exists()) {
            property = JsonContentProperty.builder((JsonContentProperty)property).content(com.atlassian.confluence.api.model.content.Content.buildReference((ContentSelector)ContentSelector.builder().id(contentId).build())).build();
        } else {
            ContentId foundId = com.atlassian.confluence.api.model.content.Content.getSelector((Reference)property.getContentRef()).getId();
            if (!contentId.equals((Object)foundId)) {
                throw new BadRequestException(String.format("Path/value mismatch. Expected %s in property but found %s", contentId, foundId));
            }
        }
        return property;
    }
}

