/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.BlockedContent;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.History;
import com.atlassian.confluence.api.model.content.MacroInstance;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.pagination.SpaceFilterAwarePageResponse;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.content.ContentDraftService;
import com.atlassian.confluence.api.service.content.ContentMacroService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.content.ContentTrashService;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.content.util.ReconcileContentAsyncOperations;
import com.atlassian.confluence.api.service.exceptions.ApiPreconditions;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.GoneException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.pagination.CursorFactory;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.plugins.restapi.graphql.GraphQLOffsetCursor;
import com.atlassian.confluence.rest.serialization.jackson2.SearchContextSerialization;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.graphql.annotations.GraphQLName;
import com.atlassian.graphql.annotations.GraphQLProvider;
import com.atlassian.graphql.annotations.expansions.GraphQLExpansionParam;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content")
@GraphQLProvider
@LimitRequestSize(value=0x500000L)
@SendsAnalytics
@Tag(name="Content Resource")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class ContentResource {
    private final ContentService contentService;
    private final SpaceService spaceService;
    private final ContentMacroService contentMacroService;
    private final ContentTrashService contentTrashService;
    private final CQLSearchService searchService;
    private final ContentDraftService contentDraftService;
    private final ObjectMapperProvider objectMapperProvider;
    private ConfluenceScopesRequestCache scopesRequestCacheDelegate;
    private final PersonService personService;

    @Inject
    public ContentResource(@ComponentImport ContentService contentService, @ComponentImport SpaceService spaceService, @ComponentImport ContentMacroService contentMacroService, @ComponentImport ContentTrashService contentTrashService, @ComponentImport CQLSearchService searchService, @ComponentImport ContentDraftService contentDraftService, ObjectMapperProvider objectMapperProvider, ConfluenceScopesRequestCache scopesRequestCacheDelegate, @ComponentImport PersonService personService) {
        this.contentService = contentService;
        this.spaceService = spaceService;
        this.contentMacroService = contentMacroService;
        this.contentTrashService = contentTrashService;
        this.searchService = searchService;
        this.contentDraftService = contentDraftService;
        this.objectMapperProvider = objectMapperProvider;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
        this.personService = personService;
    }

    @GraphQLName(value="content")
    public PageResponse<com.atlassian.confluence.api.model.content.Content> getContentByGraph(@GraphQLName(value="id") ContentId id, @GraphQLExpansionParam String expand, @GraphQLName(value="type") @DefaultValue(value="page") String type, @GraphQLName(value="spaceKey") String spaceKey, @GraphQLName(value="title") String title, @GraphQLName(value="postingDay") String postingDay, @GraphQLName(value="status") List<ContentStatus> statuses, @GraphQLName(value="version") @DefaultValue(value="0") Integer version, @GraphQLName(value="offset") @DefaultValue(value="0") int offset, @GraphQLName(value="after") String afterOffset, @GraphQLName(value="first") @DefaultValue(value="25") int limit, UriInfo uriInfo) {
        if (null == statuses) {
            statuses = Collections.emptyList();
        }
        expand = expand.replace(".edges.nodes.", ".");
        expand = expand.replace(".nodes.", ".");
        if (id != null) {
            try {
                com.atlassian.confluence.api.model.content.Content content = this.getContentById(id, statuses, version, expand, null);
                return RestList.newRestList().pageRequest((PageRequest)new SimplePageRequest(0, 1)).results(Collections.singletonList(content), false).build();
            }
            catch (NotFoundException ex) {
                return RestList.newRestList().pageRequest((PageRequest)new SimplePageRequest(0, 1)).build();
            }
        }
        return this.getContent(type, spaceKey, title, statuses, postingDay, expand, GraphQLOffsetCursor.parseOffset(offset, afterOffset), limit, Collections.emptyList(), uriInfo, null);
    }

    @Operation(summary="Get content by ID", description="Returns a piece of Content. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content/1234?expand=space,body.view,version,container`\n- `http://example.com/confluence/rest/api/content/1234?status=any`")
    @Parameters(value={@Parameter(name="id", description="the id of the content.", in=ParameterIn.PATH), @Parameter(name="status", description="list of Content statuses to filter results on. \n\n Default value: <code>[current]</code>.", in=ParameterIn.QUERY), @Parameter(name="expand", description="A comma separated list of properties to expand on the content. Default value: <code>history,space,version</code>. \n\n We can also specify some extensions such as <code>extensions.inlineProperties</code> (for getting inline comment-specific properties) or <code>extensions.resolution</code> for the resolution status of each comment in the results", in=ParameterIn.QUERY), @Parameter(name="version", description="version of the content.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns  a JSON representation of the content, or a 404 NOT FOUND if there is no content with the given id or if the user is not permitted.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{id}")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ", "READ_ALL", "JSM_KB"})
    @PublicApi
    public com.atlassian.confluence.api.model.content.Content getContentById(@GraphQLName(value="id") @DefaultValue(value="") @PathParam(value="id") ContentId id, @QueryParam(value="status") List<ContentStatus> statuses, @QueryParam(value="version") Integer version, @QueryParam(value="expand") @DefaultValue(value="history,space,version") String expand, @QueryParam(value="xoauth_requestor_id") String username) throws ServiceException {
        if (this.scopesRequestCacheDelegate != null && this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB") && username != null) {
            this.personService.setCurrentUser(username);
        }
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        ContentService.ContentFinder contentFinder = this.contentService.find(expansions);
        if (!statuses.isEmpty()) {
            contentFinder = statuses.size() == 1 && statuses.get(0).getValue().equals("any") ? contentFinder.withAnyStatus() : contentFinder.withStatus(statuses);
        }
        ContentService.SingleContentFetcher fetcher = version == null ? contentFinder.withId(id) : contentFinder.withIdAndVersion(id, version.intValue());
        Optional content = fetcher.fetch();
        return (com.atlassian.confluence.api.model.content.Content)content.orElseThrow(ServiceExceptionSupplier.notFound((String)("No content found with id: " + String.valueOf(id))));
    }

    @Operation(summary="Create content", description="Creates a new piece of Content or publishes the draft if the content id is present. For the case publishing draft, a new piece of content will be created and all metadata from the draft will be transferred into the newly created content.")
    @RequestBody(description="new content to be created.", required=true, content={@Content(schema=@Schema(implementation=com.atlassian.confluence.api.model.content.Content.class))})
    @Parameters(value={@Parameter(name="status", description="list of Content statuses to filter results on. \n\n Default value: <code>[current]</code>.", in=ParameterIn.QUERY), @Parameter(name="expand", description=" comma separated list of properties to expand on the content. Default value: <code>history,space,version</code>", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the content.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation="returned if there is no content with the given id or if the user is not permitted.", responseCode=404, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public com.atlassian.confluence.api.model.content.Content createContent(com.atlassian.confluence.api.model.content.Content content, @QueryParam(value="status") @DefaultValue(value="current") ContentStatus status, @QueryParam(value="expand") @DefaultValue(value="body.storage,history,space,container.history,container.version,version,ancestors") String expand) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        if (ContentStatus.DRAFT.equals((Object)status) && ContentStatus.CURRENT.equals((Object)content.getStatus()) && content.getId() != null) {
            return this.contentDraftService.publishNewDraft(content, expansions);
        }
        return this.contentService.create(content, expansions);
    }

    @Operation(summary="Get content", description="Returns a paginated list of Content. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content?spaceKey=TST&title=Cheese&expand=space,body.view,version,container`\n- `http://example.com/confluence/rest/api/content?type=blogpost&spaceKey=TST&title=Bacon&postingDay=2014-02-13&expand=space,body.view,version,container`")
    @Parameters(value={@Parameter(name="type", description="the content type to return. Default value: <code>page</code>. Valid values: <code>page, blogpost</code>. All types are returned if fetching via list of IDS", in=ParameterIn.QUERY), @Parameter(name="spaceKey", description=" the space key to find content under.", in=ParameterIn.QUERY), @Parameter(name="title", description=" the title of the page to find. Required for <code>page</code> type.", in=ParameterIn.QUERY), @Parameter(name="status", description=" list of statuses the content to be found is in. Defaults to current is not specified. If set to 'any', content in 'current' and 'trashed' status will be fetched. Does not support 'historical' status for now.", in=ParameterIn.QUERY), @Parameter(name="postingDay", description="the posting day of the blog post. Required for <code>blogpost</code> type. Format: <code>yyyy-mm-dd</code>. Example: <code>2013-02-13</code>", in=ParameterIn.QUERY), @Parameter(name="expand", description="a comma separated list of properties to expand on the content. Default value: <code>history,space,version</code>.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY), @Parameter(name="ids", description="a list of content ids to fetch.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a list of content.", responseCode=200, paged=true, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation="Returned if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @RateLimited(propertyName="confluence.last.mile.check.rl.content.rps", permitsPerSecond=8.0, type=RateLimited.Type.TWO_LO)
    @ScopesAllowed(requiredScope={"READ_ALL", "READ", "JSM_KB"})
    @PublicApi
    public PageResponse<com.atlassian.confluence.api.model.content.Content> getContent(@QueryParam(value="type") @DefaultValue(value="page") String type, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="title") String title, @QueryParam(value="status") List<ContentStatus> statuses, @QueryParam(value="postingDay") String postingDay, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="ids") List<String> ids, @Context UriInfo uriInfo, @QueryParam(value="xoauth_requestor_id") String username) throws ServiceException {
        SpaceFilterAwarePageResponse response;
        this.setCurrentUserIfJsmKbScope(username);
        List<ContentId> contentIds = ids == null ? Collections.emptyList() : ids.stream().map(Long::parseLong).map(ContentId::of).toList();
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        ContentService.ContentFinder parameterContentFinder = this.getContentFinder(spaceKey, title, statuses, postingDay, expand, contentIds);
        PageResponse contents = contentIds != null && contentIds.iterator().hasNext() ? parameterContentFinder.fetchManyWithAnyType((PageRequest)pageRequest) : parameterContentFinder.fetchMany(ContentType.valueOf((String)type), (PageRequest)pageRequest);
        RestList restList = RestList.newRestList((PageResponse)contents).pageRequest((PageRequest)pageRequest.copyWithLimits(contents)).build();
        contents.getTotalCount().ifPresent(totalCount -> restList.putProperty("totalCount", totalCount));
        if (contents instanceof SpaceFilterAwarePageResponse && contentIds.iterator().hasNext() && (response = (SpaceFilterAwarePageResponse)contents).getBlockedList().isPresent()) {
            Optional blockedList = response.getBlockedList();
            restList.putProperty("ignoredBySpaceFilter", ((List)blockedList.get()).stream().map(BlockedContent::getBlockedContentId).toList());
        }
        return restList;
    }

    @Operation(summary="Scan content by space key", description="Returns a paginated list of Content. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content/scan?spaceKey=TST&limit=100&expand=space,body.view,version,container`\n- `http://example.com/confluence/rest/api/content/scan?limit=100&expand=space,body.view,version,container`", extensions={@Extension(name="x-response-metadata", properties={@ExtensionProperty(name="cursorPaged", value="true")})})
    @Parameters(value={@Parameter(name="spaceKey", description=" the space key to find content under.", in=ParameterIn.QUERY), @Parameter(name="status", description=" list of statuses the content to be found is in. Defaults to current is not specified. If set to 'any', content in 'current' and 'trashed' status will be fetched. Does not support 'historical' status for now.", in=ParameterIn.QUERY), @Parameter(name="expand", description="a comma separated list of properties to expand on the content. Default value: <code>history,space,version</code>.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY), @Parameter(name="cursor", description="the identifier which is used to skip results from a previous query when paginating. Cursor is empty in first request, to move forward or backward use cursor provided in response.", in=ParameterIn.QUERY), @Parameter(name="type", description="the content type to return. Default value: <code>page</code>. Valid values: <code>page, blogpost, comment</code>. All types are returned if fetching via list of IDS. Type is only required for first request, latest request will use cursor", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a JSON representation of the list of content.", responseCode=200, paged=true, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation="returned if the user is not permitted.", responseCode=404, restError=true), @ResponseDoc(documentation="returned if the cursor is invalid.", responseCode=400, restError=true)})
    @GET
    @Path(value="/scan")
    @RateLimited(propertyName="confluence.full.sync.rl.content.rps", permitsPerSecond=2.0, type=RateLimited.Type.TWO_LO)
    @ScopesAllowed(requiredScope={"READ", "READ_ALL"})
    @PublicApi
    public PageResponse<com.atlassian.confluence.api.model.content.Content> scanContent(@QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="status") List<ContentStatus> statuses, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="cursor") String cursor, @QueryParam(value="type") String type, @Context UriInfo uriInfo) throws ServiceException {
        Cursor contentCursor;
        Optional<Object> contentType = Optional.of(ContentType.valueOf((String)type));
        if (!ContentType.BUILT_IN.contains(contentType.get())) {
            contentType = Optional.empty();
        }
        Cursor cursor2 = contentCursor = StringUtils.isEmpty((CharSequence)cursor) ? CursorFactory.getEmptyCursorBy((ContentType)contentType.orElse(ContentType.PAGE)) : CursorFactory.buildFrom((String)cursor);
        if (!(contentCursor instanceof ContentCursor)) {
            throw new BadRequestException("Cursor type is incorrect");
        }
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), contentCursor, limit);
        ContentService.ContentFinder contentFinder = this.getContentFinder(spaceKey, null, statuses, null, expand, null);
        ContentType fetchContentType = ContentResource.getContentTypeFrom(contentCursor);
        if (contentType.isPresent() && !fetchContentType.equals(contentType.get())) {
            throw new BadRequestException("Cursor type does not match with Content Type");
        }
        PageResponse contents = contentFinder.fetchManyWithoutCaching(fetchContentType, (PageRequest)pageRequest);
        RestList restList = RestList.newRestList((PageResponse)contents).pageRequest((PageRequest)pageRequest.copyWithLimits(contents)).build();
        contents.getTotalCount().ifPresent(totalCount -> restList.putProperty("totalCount", totalCount));
        return restList;
    }

    private static ContentType getContentTypeFrom(Cursor contentCursor) {
        return switch (Objects.requireNonNull(contentCursor.getCursorType())) {
            case CursorType.BLOG_POST -> ContentType.BLOG_POST;
            case CursorType.COMMENT -> ContentType.COMMENT;
            case CursorType.ATTACHMENT -> ContentType.ATTACHMENT;
            default -> ContentType.PAGE;
        };
    }

    private ContentService.ContentFinder getContentFinder(String spaceKey, String title, List<ContentStatus> statuses, String postingDay, String expand, Iterable<ContentId> contentIds) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        ContentService.ContentFinder contentFinder = this.contentService.find(expansions);
        if (!statuses.isEmpty()) {
            if (statuses.size() == 1 && statuses.get(0).getValue().equals("any")) {
                contentFinder.withAnyStatus();
            } else {
                contentFinder.withStatus(statuses);
            }
        }
        if (!Strings.isNullOrEmpty((String)spaceKey)) {
            Optional space = this.spaceService.find(new Expansion[0]).withKeys(new String[]{spaceKey}).fetch();
            if (space.isPresent()) {
                contentFinder.withSpace(new Space[]{(Space)space.get()});
            } else {
                throw new NotFoundException("No space with key : " + spaceKey);
            }
        }
        if (!Strings.isNullOrEmpty((String)title)) {
            contentFinder.withTitle(title);
        }
        if (!Strings.isNullOrEmpty((String)postingDay)) {
            contentFinder.withCreatedDate(this.convertDate(postingDay));
        }
        if (contentIds != null && contentIds.iterator().hasNext()) {
            contentFinder.withId(contentIds);
        }
        return contentFinder;
    }

    private LocalDate convertDate(String postingDayStr) {
        String[] dateParts = postingDayStr.split("-");
        int year = Integer.parseInt(dateParts[0]);
        int monthOfYear = Integer.parseInt(dateParts[1]);
        int dayOfMonth = Integer.parseInt(dateParts[2]);
        return LocalDate.of(year, monthOfYear, dayOfMonth);
    }

    @Operation(summary="Search content using CQL", description="Fetch a list of content using the Confluence Query Language (CQL). See: [Advanced searching using CQL](https://developer.atlassian.com/display/CONFDEV/Advanced+Searching+using+CQL) \n\n Example request URI(s): \n\n- `http://localhost:8080/confluence/rest/api/content/search?cql=creator=currentUser()&cqlcontext={\"spaceKey\":\"TST\", \"contentId\":\"55\"}`\n- `http://localhost:8080/confluence/rest/api/content/search?cql=space=DEV AND label=docs&expand=space,metadata.labels&limit=10`")
    @Parameters(value={@Parameter(name="cql", description="  a cql query string to use to locate content.", in=ParameterIn.QUERY), @Parameter(name="cqlcontext", description=" the context to execute a cql search in, this is the json serialized form of SearchContext", in=ParameterIn.QUERY), @Parameter(name="expand", description="a comma separated list of properties to expand on the content. Default value: <code>history,space,version</code>.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a paginated list of content.", responseCode=200, paged=true, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation="Returned if the CQL is invalid or missing.", responseCode=404, restError=true)})
    @GET
    @Path(value="/search")
    @ScopesAllowed(requiredScope={"READ", "JSM_KB"})
    @PublicApi
    public PageResponse<com.atlassian.confluence.api.model.content.Content> search(@QueryParam(value="cql") String cql, @QueryParam(value="cqlcontext") String cqlcontext, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="xoauth_requestor_id") String username, @Context UriInfo uriInfo) {
        this.setCurrentUserIfJsmKbScope(username);
        if (Strings.isNullOrEmpty((String)cql)) {
            throw new BadRequestException("CQL query parameter is required but was empty");
        }
        SearchContext cqlContextObj = SearchContextSerialization.deserializeSearchContext((String)cqlcontext, (ObjectMapper)this.objectMapperProvider.getObjectMapper());
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        if (cqlContextObj == null) {
            cqlContextObj = SearchContext.EMPTY;
        }
        SearchPageResponse results = (SearchPageResponse)this.searchService.searchContent(cql, cqlContextObj, (PageRequest)pageRequest, ExpansionsParser.parse((String)expand));
        RestList restList = RestList.newRestList((PageResponse)results).pageRequest((PageRequest)pageRequest.copyWithLimits((PageResponse)results)).build();
        restList.putProperty("cqlQuery", (Object)results.getCqlQuery());
        restList.putProperty("searchDuration", (Object)results.getSearchDuration());
        restList.putProperty("totalSize", (Object)results.totalSize());
        if (results.archivedResultCount().isPresent()) {
            restList.putProperty("archivedResultCount", results.archivedResultCount().get());
        }
        return restList;
    }

    @Operation(summary="Get history of content", description="Returns the history of a particular piece of content. Example request URI(s): \n\n- `http://example.com/confluence/rest/api/content/1234/history`\n- `http://example.com/confluence/rest/api/content/1234/history?expand=previousVersion,nextVersion,lastUpdated`\n- `http://example.com/confluence/rest/api/content/1234/history?cql=creator=currentUser()&cqlcontext={\"spaceKey\":\"TST\", \"contentId\":\"55\"}&expand=previousVersion,nextVersion,lastUpdated`\n- `http://example.com/confluence/rest/api/content/1234/history?cql=creator=currentUser()&cqlcontext={\"spaceKey\":\"TST\", \"contentId\":\"55\"}&expand=previousVersion,nextVersion,lastUpdated&start=0&limit=10`")
    @Parameters(value={@Parameter(name="id", description="  the id of the content.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the content. Default value: <code>previousVersion,nextVersion,lastUpdated</code>.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the content's history", responseCode=200, representation=History.class), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{id}/history")
    @Consumes(value={"application/json"})
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public History getHistory(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="previousVersion,nextVersion,lastUpdated") String expand) throws ServiceException {
        Expansions expansions = ExpansionsParser.parseWithPrefix((String)"history", (String)expand);
        Optional contentOption = this.contentService.find(expansions.toArray()).withId(contentId).fetch();
        com.atlassian.confluence.api.model.content.Content content = (com.atlassian.confluence.api.model.content.Content)contentOption.orElseThrow(ServiceExceptionSupplier.notFound((String)("No content with id : " + String.valueOf(contentId))));
        return (History)content.getHistoryRef().get();
    }

    @Operation(summary="Get macro body by hash", description="Returns the body of a macro (in storage format) with the given hash. This resource is primarily used by connect applications that require the body of macro to perform their work. \n\nThe hash is generated by connect during render time of the local macro holder and is usually only relevant during the scope of one request. For optimisation purposes, this hash will usually live for multiple requests. \n\nCollecting a macro by its hash should now be considered deprecated and will be replaced, transparently with macroIds. This resource is currently only called from connect addons which will eventually all use the `getContentById` resource. \n\nTo make the migration as seamless as possible, this resource will match macros against a generated hash or a stored macroId. This will allow add ons to work during the migration period.")
    @Parameters(value={@Parameter(name="id", description="  the id of the content.", in=ParameterIn.PATH), @Parameter(name="version", description="the version of the content which the hash belongs.", in=ParameterIn.PATH), @Parameter(name="hash", description="the macroId to find the correct macro.", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a json representation of a macro.", responseCode=200, representation=MacroInstance.class), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content, or there is no macro matching the given hash or id.", responseCode=404, restError=true)})
    @Deprecated
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{id}/history/{version}/macro/hash/{hash}")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public MacroInstance getMacroBodyByHash(@PathParam(value="id") ContentId contentId, @PathParam(value="version") int versionId, @PathParam(value="hash") String hash) throws ServiceException {
        return this.getMacroBodyByMacroId(contentId, versionId, hash);
    }

    @Operation(summary="Get macro body by macro ID", description="Returns the body of a macro (in storage format) with the given id. This resource is primarily used by connect applications that require the body of macro to perform their work. \n\nWhen content is created, if no macroId is specified, then Confluence will generate a random id. The id is persisted as the content is saved and only modified by Confluence if there are conflicting IDs. \n\nTo preserve backwards compatibility this resource will also match on the hash of the macro body, even if a macroId is found. This check will become redundant as pages get macroId's generated for them and transparently propagate out to all instances.")
    @Parameters(value={@Parameter(name="id", description="  the id of the content.", in=ParameterIn.PATH), @Parameter(name="version", description="the version of the content which the hash belongs.", in=ParameterIn.PATH), @Parameter(name="macroId", description="the macroId to find the correct macro.", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a json representation of a macro.", responseCode=200, representation=MacroInstance.class), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content, or there is no macro matching the given id or hash.", responseCode=404, restError=true)})
    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{id}/history/{version}/macro/id/{macroId}")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public MacroInstance getMacroBodyByMacroId(@PathParam(value="id") ContentId contentId, @PathParam(value="version") int versionId, @PathParam(value="macroId") String macroId) throws ServiceException {
        return (MacroInstance)this.contentMacroService.findInContent(contentId, new Expansion[0]).withMacroId(macroId).withContentVersion(versionId).fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No macro found on content id : " + String.valueOf(contentId) + " with version: " + versionId + " and macroId: " + macroId)));
    }

    @Operation(summary="Update content", description="Updates a piece of Content, including changes to content status. \n\nTo update a piece of content you must increment the `version.number`, supplying the number of the version you are creating. The `title` property can be updated on all content, `body` can be updated on all content that has a body (not attachments). For instance to update the content of a blogpost that currently has version 1:\n\n`PUT /rest/api/content/456`\n\n```json\n{\n   \"version\":{\n       \"number\": 2\n   },\n   \"title\":\"My new title\",\n   \"type\":\"page\",\n   \"body\":{\n        \"storage\":{\n           \"value\":\"<p>New page data.</p>\",\n           \"representation\":\"storage\"\n      }\n   }\n}\n```\n\nTo update a page and change its parent page, supply the `ancestors` property with the request with the parent as the first ancestor i.e. to move a page to be a child of page with ID 789:\n\n`PUT /rest/api/content/456`\n\n```json\n{\n   \"version\":{\n       \"number\": 2\n   },\n   \"ancestors\": [{\"id\":789}],\n   \"type\":\"page\",\n   \"body\":{\n        \"storage\":{\n           \"value\":\"<p>New page data.</p>\",\n           \"representation\":\"storage\"\n      }\n   }\n}\n```\n\nChanging status\n\nTo restore a piece of content that has the status of trashed the content must have it's `version` incremented, and `status` set to `current`. No other field modifications will be performed when restoring a piece of content from the trash.\n\nRequest example to restore from trash: `{\"id\": \"557059\",\"status\": \"current\",\"version\": {\"number\": 2}}`\n\nIf the content you're updating has a draft, specifying `status=draft` will delete that draft and the `body` of the content will be replaced with the `body` specified in the request.\n\nRequest example to delete a draft:\n\n`PUT:  http://localhost:9096/confluence/rest/api/content/2149384202?status=draft`\n\n```json\n{\n   \"id\":\"2149384202\",\n   \"status\":\"current\",\n   \"version\":{\n      \"number\":4\n   },\n   \"space\":{\n      \"key\":\"TST\"\n   },\n   \"type\":\"page\",\n   \"title\":\"page title\",\n   \"body\":{\n      \"storage\":{\n         \"value\":\"<p>New page data.</p>\",\n         \"representation\":\"storage\"\n      }\n   }\n}\n```\n\nChanging page position\n\nTo set page position, supply the `position` property in the request body with a positive integer. Content with unset positions will have a `position` value of -1. To unset a content position, supply `position` property with -1.\n\nRequest example to set page position to 1\n\n`PUT /rest/api/content/2149384202`\n\n```json\n{\n   \"id\":\"2149384202\",\n   \"version\":{\n      \"number\":2\n   },\n   \"type\":\"page\",\n   \"title\":\"page title\",\n   \"position\":1\n}\n```\n\n Request example to unset page position \n\n`PUT /rest/api/content/2149384202`\n\n```json\n{\n   \"id\":\"2149384202\",\n   \"version\":{\n      \"number\":2\n   },\n   \"type\":\"page\",\n   \"position\":-1\n}\n```\n\n")
    @Parameters(value={@Parameter(name="contentId", description="  the id of the content.", in=ParameterIn.PATH), @Parameter(name="status", description="the existing status of the content to be updated.", in=ParameterIn.QUERY), @Parameter(name="conflictPolicy", description="the conflict policy, default value: <code>abort<code>", in=ParameterIn.QUERY)})
    @RequestBody(description="new content to be created.", required=true, content={@Content(schema=@Schema(implementation=com.atlassian.confluence.api.model.content.Content.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of a piece of content.", responseCode=200, representation=com.atlassian.confluence.api.model.content.Content.class), @ResponseDoc(documentation="Returned if no space or no content type, or setup a wrong version type set to content, or status param is not draft and status content is current", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if can not find draft with current content.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{contentId}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public com.atlassian.confluence.api.model.content.Content update(@PathParam(value="contentId") ContentId contentId, com.atlassian.confluence.api.model.content.Content content, @QueryParam(value="status") ContentStatus status, @QueryParam(value="conflictPolicy") @DefaultValue(value="abort") ContentDraftService.ConflictPolicy conflictPolicy, @QueryParam(value="asyncReconciliation") @DefaultValue(value="false") boolean asyncReconciliation) throws ServiceException {
        com.atlassian.confluence.api.model.content.Content contentToUpdate;
        ApiPreconditions.checkRequestArgs((content.getId() == null || content.getId().equals((Object)contentId) ? 1 : 0) != 0, (String)"content id mismatch");
        com.atlassian.confluence.api.model.content.Content content2 = contentToUpdate = content.getId() == null ? com.atlassian.confluence.api.model.content.Content.builder((com.atlassian.confluence.api.model.content.Content)content).id(contentId).build() : content;
        if (status != null) {
            if (ContentStatus.DRAFT.equals((Object)status)) {
                if (!ContentStatus.CURRENT.equals((Object)contentToUpdate.getStatus())) {
                    throw new BadRequestException("Updating a draft without publishing is not possible");
                }
                return (com.atlassian.confluence.api.model.content.Content)ReconcileContentAsyncOperations.callWithAsyncFlagAwareness(() -> this.contentDraftService.publishEditDraft(contentToUpdate, conflictPolicy), (boolean)asyncReconciliation);
            }
            Optional existingContent = this.contentService.find(new Expansion[0]).withStatus(new ContentStatus[]{status}).withId(contentId).fetch();
            if (existingContent.isEmpty()) {
                Optional trashedContent = this.contentService.find(new Expansion[0]).withStatus(new ContentStatus[]{ContentStatus.TRASHED}).withId(contentId).fetch();
                if (trashedContent.isPresent()) {
                    throw new GoneException("Content was trashed.");
                }
                throw new NotFoundException("Content can't be found.");
            }
        }
        return this.contentService.update(contentToUpdate);
    }

    @Operation(summary="Delete content", description="Trashes or purges a piece of Content, based on its ContentType and ContentStatus. \n\nThere are three cases:\n\n- If the content is trashable and its status is current, it will be trashed.\n\n- If the content is trashable, its status is trashed and the status query parameter in the request is trashed, the content will be purged from the trash and deleted permanently.\n\n- If the content is not trashable it will be deleted permanently without being trashed.")
    @Parameters(value={@Parameter(name="id", description="  the id of the content.", in=ParameterIn.PATH), @Parameter(name="status", description="the status of the content to be deleted.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returned if successfully trashed.", responseCode=200), @ResponseDoc(documentation="Returned if successfully purged.", responseCode=204), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to trash or purge the content.", responseCode=404, restError=true), @ResponseDoc(documentation="Returned if there is a stale data object conflict when trying to delete a draft.", responseCode=409, restError=true)})
    @DELETE
    @Path(value="/{id}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response delete(@PathParam(value="id") ContentId contentId, @QueryParam(value="status") ContentStatus status) throws ServiceException {
        com.atlassian.confluence.api.model.content.Content content = com.atlassian.confluence.api.model.content.Content.builder().id(contentId).status(status).build();
        if (ContentStatus.TRASHED.equals((Object)status)) {
            this.contentTrashService.purge(content);
            return Response.noContent().build();
        }
        if (ContentStatus.DRAFT.equals((Object)status)) {
            this.contentDraftService.deleteDraft(contentId);
            return Response.noContent().build();
        }
        if (status != null && !status.equals((Object)ContentStatus.CURRENT)) {
            throw new BadRequestException("Specified status for Content DELETE can only be 'current', 'draft' or 'trashed'");
        }
        this.contentService.delete(content);
        return Response.noContent().build();
    }

    private void setCurrentUserIfJsmKbScope(String username) {
        if (this.scopesRequestCacheDelegate != null && this.scopesRequestCacheDelegate.isScopePermitted("JSM_KB") && username != null) {
            this.personService.setCurrentUser(username);
        }
    }
}

