/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.permissions.ContentRestriction;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.RelevantViewRestrictions;
import com.atlassian.confluence.api.service.permissions.ContentRestrictionService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.plugins.restapi.resources.util.MockRestrictionsResponse;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;

@AnonymousSiteAccess
@LimitRequestSize
@SendsAnalytics
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/restriction")
@Tag(name="Content Restrictions")
@PathParamDoc(name="id", documentation="The id of the content")
public class ContentRestrictionResource {
    private final ContentRestrictionService service;

    @Inject
    public ContentRestrictionResource(@ComponentImport ContentRestrictionService service) {
        this.service = service;
    }

    @Operation(description="Returns relevant view restriction both direct and inherited for a single content.", summary="Get all view restriction both direct and inherited.")
    @Parameters(value={@Parameter(name="expand", description="A comma separated list of properties to expand on the content properties. Default value: relevantViewRestrictions", in=ParameterIn.QUERY), @Parameter(name="start", description="pagination start.", in=ParameterIn.QUERY), @Parameter(name="limit", description="pagination limit, Max 50 per page", in=ParameterIn.QUERY)})
    @ResponseDoc(documentation="Returns a JSON representation of the restrictions group by operations.", responseCode=200, representation=MockRestrictionsResponse.class)
    @GET
    @Path(value="relevantViewRestrictions")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public RelevantViewRestrictions relevantViewRestrictions(@PathParam(value="id") ContentId id, @QueryParam(value="expand") @DefaultValue(value="relevantViewRestrictions") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="50") int limit) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        LimitedRequest limitedRequest = LimitedRequestImpl.create((int)start, (int)limit, (int)Integer.parseInt("50"));
        return this.service.getRelevantViewRestrictionsForSingleContent(limitedRequest, id, new Expansions(expansions));
    }

    @Operation(description="Returns info about all restrictions by operation.", summary="Get all restrictions by Operation")
    @Parameter(name="expand", description="A comma separated list of properties to expand on the content properties. Default value: group.", in=ParameterIn.QUERY)
    @ResponseDoc(documentation="Returns a JSON representation of the restrictions group by operations.", responseCode=200, representation=MockRestrictionsResponse.class)
    @GET
    @Path(value="byOperation")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public Map<OperationKey, ContentRestriction> byOperation(@PathParam(value="id") ContentId id, @QueryParam(value="expand") @DefaultValue(value="update.restrictions.user,read.restrictions.group,read.restrictions.user,update.restrictions.group") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.service.getRestrictionsGroupByOperation(id, expansions);
    }

    @Operation(description="Returns info about all restrictions of given operation.", summary="Get all restrictions for given operation")
    @Parameters(value={@Parameter(name="operationKey", description="key of the operation.", in=ParameterIn.PATH), @Parameter(name="expand", description="Aa comma separated list of properties to expand on the content properties. Default value: group.", in=ParameterIn.QUERY), @Parameter(name="start", description="pagination start.", in=ParameterIn.QUERY), @Parameter(name="limit", description="pagination limit.", in=ParameterIn.QUERY)})
    @ResponseDoc(documentation="Returns a JSON representation of the restrictions of given operation.", responseCode=200, representation=MockRestrictionsResponse.OperationRestriction.class)
    @GET
    @Path(value="byOperation/{operationKey}")
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public ContentRestriction forOperation(@PathParam(value="id") ContentId id, @PathParam(value="operationKey") OperationKey opKey, @QueryParam(value="expand") @DefaultValue(value="restrictions.user,restrictions.group") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        SimplePageRequest pageRequest = new SimplePageRequest(start, limit);
        return this.service.getRestrictionsForOperation(id, opKey, (PageRequest)pageRequest, expansions);
    }

    @Operation(summary="Update restrictions", description="Sets all the restrictions specified to a piece of content identified by `contentId`. Setting per-content restrictions is currently allowed for Pages or BlogPosts only. \n\nExample request URI: \n\n`http://example.com/confluence/rest/content/1234567/restriction?expand=`\n\nThe payload uses the same schema as returned by the GET requests from `/rest/api/content/{id}/restriction/byOperation*` which can be used as a template but is not necessary. \n\nExample request for a single content restriction: \n\n```json\n[ { \"operation\": \"update\", \"restrictions\": { \"user\": [ { \"type\": \"known\", \"username\": \"admin\" } ] } } ]\n```\n\nExample request for updating two ContentRestrictions: \n\n```json\n[ { \"operation\": \"update\", \"restrictions\": { \"user\": [ { \"type\": \"known\", \"username\": \"admin\" } ] } }, { \"operation\": \"read\", \"restrictions\": { \"user\": [ { \"type\": \"known\", \"username\": \"fred\" } ] } } ]\n```\n\nRules for using this method: \n\n- The provided ContentRestrictions will overwrite any existing restrictions on the Content for the corresponding operations. \n- If the provided `ContentRestriction` lacks any supported operations, the restrictions for the operations will not be altered. \n- Setting `users` and/or `groups` map entries as empty arrays will remove the corresponding content restrictions. \n- Missing `users` and/or `groups` map entries means the corresponding operation's user/group content restrictions won't be changed. \n- Modifying restrictions to revoke the requesting user's access is prohibited.")
    @Parameters(value={@Parameter(name="expand", description="A comma separated list of properties to expand in the response. Default is <code>restrictions.user, restrictions.group</code> Default value: group.", in=ParameterIn.QUERY), @Parameter(name="start", description="pagination start.", in=ParameterIn.QUERY), @Parameter(name="limit", description="pagination limit.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the restrictions present directly on piece of content after the update operation.", responseCode=200, representation=MockRestrictionsResponse.OperationRestriction.class, paged=true), @ResponseDoc(documentation="Returned if any of the above validation rules are violated.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the calling user is not authenticated.", responseCode=401, restError=true), @ResponseDoc(documentation="Returned if the calling user does not have permission to edit the restrictions.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @PUT
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public PageResponse<ContentRestriction> updateRestrictions(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="restrictions.user,restrictions.group") String expand, List<ContentRestriction> contentRestrictions) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return this.service.updateRestrictions(contentId, contentRestrictions, expansions);
    }
}

