/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentVersionService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/version")
@LimitRequestSize(value=0x500000L)
@SendsAnalytics
@Tag(name="Content Version")
@PathParamDoc(name="id", documentation="The id of the content")
public class ContentVersionResource {
    private final ContentVersionService contentVersionService;

    @Inject
    public ContentVersionResource(@ComponentImport ContentVersionService contentVersionService) {
        this.contentVersionService = contentVersionService;
    }

    @Operation(summary="Delete content history", description="Delete a historical version of a page or a blogpost. Current user must have edit permission on content, or it will throw a permission exception.")
    @Parameter(name="versionNumber", description="version number starts from 1 up to current version.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a Successful deletion of a page/blogpost version.", responseCode=204), @ResponseDoc(documentation="Returned if versionNumber is less than 1, does not exist or has already been deleted.", responseCode=400, restError=true), @ResponseDoc(documentation="Returned if the calling user doesn't have permission to edit the content.", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if the contentId cannot be found.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{versionNumber}")
    @ScopesAllowed(requiredScope={"WRITE"})
    @PublicApi
    public Response deleteContentHistory(@PathParam(value="id") ContentId contentId, @PathParam(value="versionNumber") int versionNumber) {
        this.contentVersionService.delete(contentId, versionNumber);
        return Response.noContent().build();
    }
}

