/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.watch.WatchService;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@Path(value="/content/{contentId}/watchers")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Tag(name="Content Watchers")
@PathParamDoc(name="contentId", documentation="the ID of the Content the User is attempting to view the watchers for.")
@SendsAnalytics
public final class ContentWatcherResource {
    private final WatchService watchService;

    @Inject
    public ContentWatcherResource(@ComponentImport WatchService watchService) {
        this.watchService = watchService;
    }

    @Operation(description="Returns a paginated list of Users watching the given Content identified by contentId. Only a Confluence Administrator or Space Administrator can perform this action.", summary="Fetch users watching a given content")
    @Parameters(value={@Parameter(name="start", description="The start point of the collection to return.", in=ParameterIn.QUERY), @Parameter(name="limit", description="The limit of the number of users to return, this may be restricted by fixed system limit.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The list of Users watching the Content.", representation=User.class, paged=true), @ResponseDoc(responseCode=400, documentation="Returned if the requested Content is not of type BlogPost or Page.", restError=true), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User is not a Confluence Administrator or Space Administrator.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if the Content does not exist.", restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<User> index(@Context UriInfo uriInfo, @PathParam(value="contentId") ContentId contentId, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit) {
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse users = this.watchService.findUsersWatchingContentPaginated(contentId, (PageRequest)pageRequest);
        return RestList.newRestList((PageResponse)users).pageRequest((PageRequest)pageRequest.copyWithLimits(users)).build();
    }
}

