/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ChildContentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.confluence.rest.v2.api.model.pagination.PaginationLimits;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/content/{id}/descendant")
@Tag(name="Content Descendant")
@PathParamDoc(name="id", documentation="the ID of the Content the User is attempting to view the descendants for.")
public class DescendantContentResource {
    private final ChildContentService childContentService;

    @Inject
    public DescendantContentResource(@ComponentImport ChildContentService childContentService) {
        this.childContentService = childContentService;
    }

    @Operation(summary="Get Descendants", description="Returns a map of the descendants of a piece of Content. Content can have multiple types of descendants - for example a Page can have descendants that are also Pages, but it can also have Comments and Attachments. \n\nThe ContentType(s) of the descendants returned is specified by the `expand` query parameter in the request - this parameter can include expands for multiple descendant types. If no types are included in the expand parameter, the map returned will just list the descendant types that are available to be expanded for the Content referenced by the `id` path parameter. \n\nCurrently the only supported descendants are comment descendants of non-comment Content. \n\nExample request URI(s): \n\n`http://example.com/confluence/rest/api/content/1234/descendant` \n\n`http://example.com/confluence/rest/api/content/1234/descendant?expand=comment.body.VIEW` \n\n`http://example.com/confluence/rest/api/content/1234/descendant?expand=comment`")
    @Parameter(name="expand", description=" a comma separated list of properties to expand on the descendants.", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a JSON map representing multiple ordered collections of content descendants,keyed by content type.", responseCode=200, representation=Content.class, paged=true), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public Map<ContentType, PageResponse<Content>> descendants(@PathParam(value="id") ContentId contentId, @QueryParam(value="expand") @DefaultValue(value="") String expand, @Context UriInfo uriInfo) throws ServiceException {
        Expansions expansions = ExpansionsParser.parseAsExpansions((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), 0, PaginationLimits.childMap((Expansions)expansions));
        return this.childContentService.findContent(contentId, expansions.toArray()).withDepth(Depth.ALL).fetchMappedByType((PageRequest)pageRequest);
    }

    @Operation(summary="Get descendants of type", description="Returns the direct descendants of a piece of Content. The ContentType(s) of the descendants returned is specified by the `type` path parameter in the request. Currently the only supported descendants are comment descendants of non-comment Content. \n\nExample request URI(s): \n\n`http://example.com/confluence/rest/api/content/1234/descendant/comment` \n\n`http://example.com/confluence/rest/api/content/1234/descendant/comment?expand=body.VIEW` \n\n`http://example.com/confluence/rest/api/content/1234/descendant/comment?start=20&limit=10`")
    @Parameters(value={@Parameter(name="type", description=" content type to filter descendants on.", in=ParameterIn.PATH), @Parameter(name="expand", description="a comma separated list of properties to expand on the descendants.", in=ParameterIn.QUERY), @Parameter(name="start", description="(optional, default: 0) the index of the first item within the result set that should be returned.", in=ParameterIn.QUERY), @Parameter(name="limit", description=" (optional, default: site limit) how many items should be returned after the start index.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a JSON map representing multiple ordered collections of content descendants, keyed by content type.", responseCode=200, representation=Content.class, paged=true), @ResponseDoc(documentation="Returned if there is no content with the given id, or if the calling user does not have permission to view the content.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{type}")
    @ScopesAllowed(requiredScope={"READ"})
    public RestList<Content> descendantsOfType(@PathParam(value="id") ContentId contentId, @PathParam(value="type") ContentType type, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="25") int limit, @Context UriInfo uriInfo) throws ServiceException {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        PageResponse descendants = this.childContentService.findContent(contentId, expansions).withDepth(Depth.ALL).fetchMany(type, (PageRequest)pageRequest);
        return RestList.createRestList((PageRequest)pageRequest, (PageResponse)descendants);
    }
}

