/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.api.colorscheme.ColorSchemeThemeBasedModel;
import com.atlassian.confluence.api.service.colorscheme.GlobalColorSchemeService;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/color-scheme")
@Tag(name="GlobalColorScheme")
public class GlobalColorSchemeResource {
    private final GlobalColorSchemeService globalColorSchemeService;

    @Inject
    GlobalColorSchemeResource(@ComponentImport GlobalColorSchemeService globalColorSchemeService) {
        this.globalColorSchemeService = globalColorSchemeService;
    }

    @Operation(summary="Get global color scheme", description="Get information about the current color scheme for the instance\n\n")
    @ResponseDoc(documentation="Returns a full JSON representation of color scheme including light and dark theme", responseCode=200, representation=ColorSchemeThemeBasedModel.class)
    @UnrestrictedAccess
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    public ColorSchemeThemeBasedModel getGlobalColorScheme() {
        return this.globalColorSchemeService.getColorScheme();
    }

    @Operation(summary="Get default global color scheme", description="Get default color scheme for the instance\n\n")
    @ResponseDoc(documentation="Returns a full JSON representation of color scheme including light and dark theme", responseCode=200, representation=ColorSchemeThemeBasedModel.class)
    @AdminOnly
    @GET
    @Path(value="/default")
    public ColorSchemeThemeBasedModel getDefaultColorScheme() {
        return this.globalColorSchemeService.getDefaultColorScheme();
    }

    @Operation(summary="Set global color scheme", description="Update the current color scheme of the instance\n\n")
    @RequestBody(description="New color scheme", content={@Content(schema=@Schema(implementation=ColorSchemeThemeBasedModel.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of the updated color scheme", responseCode=200, representation=ColorSchemeThemeBasedModel.class), @ResponseDoc(documentation="Returned if the user is not a site admin", responseCode=403, restError=true), @ResponseDoc(documentation="Returned if there are invalid colors in the request", responseCode=400, restError=true)})
    @AdminOnly
    @PUT
    public ColorSchemeThemeBasedModel updateColorScheme(ColorSchemeThemeBasedModel colorSchemeModel) {
        this.globalColorSchemeService.setColorScheme(colorSchemeModel);
        return this.globalColorSchemeService.getColorScheme();
    }

    @Operation(summary="Reset global color scheme", description="Reset the global color scheme colors to default\n\n")
    @ResponseDocs(value={@ResponseDoc(documentation="Returns a full JSON representation of color scheme", responseCode=200, representation=ColorSchemeThemeBasedModel.class), @ResponseDoc(documentation="Returned if the user is not a site admin", responseCode=403, restError=true)})
    @AdminOnly
    @PUT
    @Path(value="/reset")
    public ColorSchemeThemeBasedModel resetGlobalColorScheme() {
        this.globalColorSchemeService.resetColorScheme();
        return this.globalColorSchemeService.getColorScheme();
    }
}

