/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.GlobalPermission;
import com.atlassian.confluence.api.model.permissions.OperationDescription;
import com.atlassian.confluence.api.model.permissions.SpacePermissionsForSubject;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.service.permissions.GlobalPermissionService;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AdminOnly
@SendsAnalytics
@Path(value="/permissions")
@Tag(name="Global Permissions")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class GlobalPermissionResource {
    private final GlobalPermissionService globalPermissionService;

    @Inject
    public GlobalPermissionResource(@ComponentImport GlobalPermissionService globalPermissionService) {
        this.globalPermissionService = globalPermissionService;
    }

    @Operation(summary="Get global permissions", description="Returns list of permissions granted to users and groups.\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions`")
    @ApiResponse(responseCode="200", description="Returns a JSON representation of all global permissions granted to users/groups/anonymous user.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=GlobalPermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true)})
    @GET
    @RateLimited(propertyName="confluence.full.sync.rl.permissions.global.rps", permitsPerSecond=10.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getAllGlobalPermissions() {
        List globalPermissions = this.globalPermissionService.getAllPermissions();
        return Response.ok((Object)globalPermissions).build();
    }

    @Operation(summary="Gets global permissions granted to a user", description="Returns list of permissions granted to user.\n\nExample request URI's:\n\n       with userKey: `https://example.com/confluence/rest/api/permissions/user/{userKey}`\n\n       with username: `https://example.com/confluence/rest/api/permissions/user/{username}`")
    @Parameter(name="user", description="the key or username of the user to look up.", in=ParameterIn.PATH)
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the permissions granted to the user.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=GlobalPermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if the user with specified key not found.", restError=true)})
    @GET
    @Path(value="/user/{user}")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getPermissionsGrantedToUser(@PathParam(value="user") String user) {
        List globalPermissions = this.globalPermissionService.getPermissionsGrantedToUser(this.constructUser(user));
        return Response.ok((Object)globalPermissions).build();
    }

    @Operation(summary="Gets global permissions granted to a group", description="Returns list of permissions granted to group.\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions/group/{groupName}}`")
    @Parameter(name="groupName", description="the name of the group to look up.", in=ParameterIn.PATH)
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the permissions granted to the group.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=GlobalPermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling user does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if the user with specified key not found.", restError=true)})
    @GET
    @Path(value="/group/{groupName}")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getPermissionsGrantedToGroup(@PathParam(value="groupName") String groupName) {
        List globalPermissions = this.globalPermissionService.getPermissionsGrantedToGroup(groupName);
        return Response.ok((Object)globalPermissions).build();
    }

    @Operation(summary="Gets the permissions granted to an anonymous user", description="Returns list of permissions granted to anonymous user.\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions/anonymous`")
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the permissions granted to the group.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=GlobalPermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true)})
    @GET
    @Path(value="/anonymous")
    @RateLimited
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getPermissionsGrantedToAnonymousUsers() {
        List globalPermissions = this.globalPermissionService.getPermissionsGrantedToAnonymousUsers();
        return Response.ok((Object)globalPermissions).build();
    }

    @Operation(summary="Gets the permissions granted to an unlicensed users", description="Returns list of permissions granted to unlicensed users.\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions/unlicensed`")
    @ApiResponse(responseCode="200", description="Returns a JSON representation of the permissions granted to the group.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=GlobalPermission.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true)})
    @GET
    @Path(value="/unlicensed")
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Response getPermissionsGrantedToUnlicensedUsers() {
        List globalPermissions = this.globalPermissionService.getPermissionsGrantedToUnlicensedUsers();
        return Response.ok((Object)globalPermissions).build();
    }

    @Operation(summary="Grants global permissions to a group", description="Grant global permissions to a group.\n\nOperation doesn't override existing permissions, will only add those one that weren't granted before.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use\n* application administer\n* system administer\n* personal_space create\n* space create\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Global+Permissions+Overview\">Global Permissions documentation</a> for additional information about supported permissions.\n\n\nExample request URI's:\n\n`https://example.com/confluence/rest/api/permissions/group/test-group-name/grant`")
    @Parameter(name="groupName", description="the name of the group to look up.", in=ParameterIn.PATH)
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully granted to a group."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if group with specified name not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="group/{groupName}/grant")
    public Response grantPermissionsToGroup(@PathParam(value="groupName") String groupName, Set<OperationDescription> permissions) {
        this.globalPermissionService.grantPermissionsToGroup(groupName, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Revoke global permissions from a group", description="Revoke global permissions from a group.\n\nWhen 'application use' is revoked, all granted permissions will be removed from target group.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use\n* application administer\n* system administer\n* personal_space create\n* space create\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Global+Permissions+Overview\">Global Permissions documentation</a> for additional information about supported permissions.\n\n\nExample request URI's:\n\n`https://example.com/confluence/rest/api/permissions/group/test-group-name/revoke`")
    @Parameter(name="groupName", description="the name of the group to look up.", in=ParameterIn.PATH)
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully revoked from a group."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if group with specified name not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or global permission).", restError=true)})
    @PUT
    @Path(value="group/{groupName}/revoke")
    public Response revokePermissionsFromGroup(@PathParam(value="groupName") String groupName, Set<OperationDescription> permissions) {
        this.globalPermissionService.revokePermissionsFromGroup(groupName, permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Grants global permissions to a user", description="Grant global permissions to a user.\n\nOperation doesn't override existing permissions, will only add those one that weren't granted before.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use\n* application administer\n* system administer\n* personal_space create\n* space create\n\nExample request URI's:\n\nwith userKey: `https://example.com/confluence/rest/api/permissions/user/{userKey}/grant`\n\nwith username: `https://example.com/confluence/rest/api/permissions/user/{username}/grant`")
    @Parameter(name="user", description="the key or username of the user to look up.", in=ParameterIn.PATH)
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully granted to a user."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if user with specified user key or user name not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or space permission).", restError=true)})
    @PUT
    @Path(value="user/{user}/grant")
    public Response grantPermissionsToUser(@PathParam(value="user") String user, Set<OperationDescription> permissions) {
        this.globalPermissionService.grantPermissionsToUser(this.constructUser(user), permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Revoke global permissions from a user", description="Revoke global permissions from a user.\n\nWhen 'application use' is revoked, all granted permissions will be removed from target user.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use\n* application administer\n* system administer\n* personal_space create\n* space create\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Global+Permissions+Overview\">Global Permissions documentation</a> for additional information about supported permissions.\n\n\nExample request URI's:\n\nwith userKey: `https://example.com/confluence/rest/api/permissions/user/{userKey}/revoke`\n\nwith username: `https://example.com/confluence/rest/api/permissions/user/{username}/revoke`")
    @Parameter(name="user", description="the key or username of the user to look up.", in=ParameterIn.PATH)
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully revoked from a user."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if user with specified user key or user name not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or space permission).", restError=true)})
    @PUT
    @Path(value="user/{user}/revoke")
    public Response revokePermissionsFromUser(@PathParam(value="user") String user, Set<OperationDescription> permissions) {
        this.globalPermissionService.revokePermissionsFromUser(this.constructUser(user), permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Grants global permissions to anonymous users", description="Grant global permissions to anonymous users.\n\nOperation doesn't override existing permissions, will only add those one that weren't granted before.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use\n* read user\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions/anonymous/grant`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully granted to anonymous users."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or space permission).", restError=true)})
    @PUT
    @Path(value="anonymous/grant")
    public Response grantPermissionsToAnonymousUsers(Set<OperationDescription> permissions) {
        this.globalPermissionService.grantPermissionsToAnonymousUsers(permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Revoke global permissions from anonymous users", description="Revoke global permissions from anonymous users.\n\nWhen 'application use' is revoked, all granted permissions will be removed from anonymous users.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use\n* read user\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions/anonymous/revoke`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully revoked from anonymous users."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or space permission).", restError=true)})
    @PUT
    @Path(value="anonymous/revoke")
    public Response revokePermissionsFromAnonymousUsers(Set<OperationDescription> permissions) {
        this.globalPermissionService.revokePermissionsFromAnonymousUsers(permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Grants global permissions to unlicensed users", description="Grant global permissions to unlicensed users.\n\nOperation doesn't override existing permissions, will only add those one that weren't granted before.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use_unlicensed\n* read user\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions/unlicensed/grant`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully granted to unlicensed users."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or space permission).", restError=true)})
    @PUT
    @Path(value="unlicensed/grant")
    public Response grantPermissionsToUnlicensedUsers(Set<OperationDescription> permissions) {
        this.globalPermissionService.grantPermissionsToUnlicensedUsers(permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Revoke global permissions from unlicensed users", description="Revoke global permissions from unlicensed users.\n\nWhen 'application use_unlicensed' is revoked, all granted permissions will be removed from unlicensed users.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use_unlicensed\n* read user\n\nExample request URI's:\n\n       `https://example.com/confluence/rest/api/permissions/unlicensed/revoke`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=OperationDescription.class)))})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully revoked from unlicensed users."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or space permission).", restError=true)})
    @PUT
    @Path(value="unlicensed/revoke")
    public Response revokePermissionsFromUnlicensedUsers(Set<OperationDescription> permissions) {
        this.globalPermissionService.revokePermissionsFromUnlicensedUsers(permissions);
        return Response.noContent().build();
    }

    @Operation(summary="Set global permissions to multiple users/groups", description="Sets global permissions to multiple users/groups.\n\nRequest should contain all permissions that users/groups will have.\n\nIf permission is absent in the request, but was granted before, it will be revoked.\n\nIf empty list of permissions passed to users/groups, then all their existing permissions will be revoked.\n\nIf users/groups not mentioned in the request, their permissions will not be revoked.\n\n\nMaximum 40 different users/groups could be passed in the request by default\n.\n\nMultiple permissions could be passed in one request. Supported targetType and operationKey pairs:\n\n* application use\n* application administer\n* system administer\n* personal_space create\n* space create\n\nSee <a href=\"https://confluence.atlassian.com/display/DOC/Global+Permissions+Overview\">Global Permissions documentation</a> for additional information about supported permissions.\n\n\nExample request URI's:\n`https://example.com/confluence/rest/api/permissions`")
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=SpacePermissionsForSubject.class)), examples={@ExampleObject(value="[\n    {\n        \"userKey\": \"4028ae289154667d0191546e11a10001\",\n        \"operations\": [\n            {\n                \"operationKey\": \"create\",\n                \"targetType\": \"space\"\n            },\n            {\n                \"operationKey\": \"use\",\n                \"targetType\": \"application\"\n            }\n        ]\n    },\n    {\n        \"groupName\": \"group1\",\n        \"operations\": [\n            {\n                \"operationKey\": \"create\",\n                \"targetType\": \"personal_space\"\n            },\n           {\n                \"operationKey\": \"use\",\n                \"targetType\": \"application\"\n            },\n            {\n                \"operationKey\": \"administer\",\n                \"targetType\": \"application\"\n            }\n        ]\n    }\n]\n")})})
    @ResponseDocs(value={@ResponseDoc(responseCode=204, documentation="Global permissions successfully set."), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true), @ResponseDoc(responseCode=404, documentation="Returned if user or group with specified key not found.", restError=true), @ResponseDoc(responseCode=400, documentation="Returned if incorrect permissions are passed in request (for e.g. non existing operation or space permission).", restError=true)})
    @PUT
    public Response setPermissions(Set<SpacePermissionsForSubject> permissionsForSubjects) {
        this.globalPermissionService.setPermissions(permissionsForSubjects);
        return Response.noContent().build();
    }

    private User constructUser(String user) {
        return new User((Icon)null, user, null, user);
    }
}

