/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ContentTooLongException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.internal.api.security.ConfluenceScopesRequestCache;
import com.atlassian.confluence.plugins.restapi.resources.OptionalServiceProvider;
import com.atlassian.confluence.plugins.restapi.resources.webhooks.WebhooksResourceHelper;
import com.atlassian.confluence.plugins.restapi.resources.webhooks.WebhooksRestResponseBuilder;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.webhooks.Webhook;
import com.atlassian.webhooks.WebhookScope;
import com.atlassian.webhooks.history.DetailedInvocation;
import com.atlassian.webhooks.internal.rest.RestWebhook;
import com.atlassian.webhooks.internal.rest.history.RestInvocationHistory;
import com.google.common.collect.ImmutableSet;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Set;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/webhooks")
@Tag(name="Webhooks")
public class GlobalWebhooksResource {
    private static final int ALLOWED_URL_CONTENT_LENGTH = 2000;
    private static final Set<String> ALLOWED_SCHEMES = ImmutableSet.of((Object)"http", (Object)"https");
    private static final Set<String> BLOCKED_HOSTS_REGEX = ImmutableSet.of((Object)"^0.0.0.0$", (Object)"^169.254.\\d{1,3}\\.\\d{1,3}$", (Object)"^127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$", (Object)"^0:0:0:0:0:0:[a-z0-9]{1,4}:[a-z0-9]{1,4}");
    private static final boolean WEBHOOKS_ALLOW_ALL_HOSTS = Boolean.getBoolean("confluence.webhooks.allow.all.hosts");
    private final PermissionEnforcer permissionEnforcer;
    private final WebhooksResourceHelper webhooksResourceHelper;
    private final I18nResolver i18nResolver;
    private final ConfluenceScopesRequestCache scopesRequestCache;

    @Inject
    public GlobalWebhooksResource(@ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionEnforcer permissionEnforcer, OptionalServiceProvider optionalServiceProvider, ConfluenceScopesRequestCache scopesRequestCache) {
        this.permissionEnforcer = permissionEnforcer;
        this.i18nResolver = i18nResolver;
        this.scopesRequestCache = scopesRequestCache;
        this.webhooksResourceHelper = new WebhooksResourceHelper(i18nResolver, new WebhooksRestResponseBuilder(), () -> optionalServiceProvider.getInvocationHistoryService().orElseThrow(NotFoundException::new), () -> optionalServiceProvider.getWebhookService().orElseThrow(NotFoundException::new), scope -> this.enforceReadAllScopeOrAdmin());
    }

    @Operation(summary="Create webhook", description="Create a webhook via the URL. The authenticated user must be an administrator to call this resource.")
    @RequestBody(description="the webhook to be created.", required=true, content={@Content(schema=@Schema(implementation=RestWebhook.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a created webhook.", responseCode=201, representation=Webhook.class), @ResponseDoc(documentation="returned if The webhook parameters were invalid or not supplied.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create webhooks.", responseCode=401, restError=true)})
    @POST
    @ScopesAllowed(requiredScope={"ADMIN", "MANAGE_SUBSCRIPTIONS"})
    public Response createWebhook(@Context UriInfo uriInfo, RestWebhook webhook) throws ContentTooLongException {
        this.validateUrl(webhook.getUrl());
        return this.webhooksResourceHelper.createWebhook(uriInfo, WebhookScope.GLOBAL, webhook);
    }

    @Operation(summary="Delete webhook", description="Delete a webhook via the URL. The authenticated user must be an administrator to call this resource.")
    @Parameter(name="webhookId", description="the id of the webhook to be deleted.", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="returned if deleted successfully.", responseCode=204), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to delete webhooks.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if the webhook does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{webhookId}")
    @ScopesAllowed(requiredScope={"ADMIN", "MANAGE_SUBSCRIPTIONS"})
    public Response deleteWebhook(@PathParam(value="webhookId") int webhookId) {
        return this.webhooksResourceHelper.deleteWebhook(WebhookScope.GLOBAL, webhookId);
    }

    @Operation(summary="Find webhooks", description="Find webhooks. The authenticated user must be an administrator to call this resource.")
    @Parameters(value={@Parameter(name="event", description="list of webhook event ids to filter for", in=ParameterIn.QUERY), @Parameter(name="statistics", description="if statistics should be provided for all found webhooks.", in=ParameterIn.QUERY), @Parameter(name="start", description="the start point of the collection to return", in=ParameterIn.QUERY), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a list of webhooks.", responseCode=200, representation=RestWebhook.class, paged=true), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to find webhooks.", responseCode=401, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"ADMIN", "READ_ALL"})
    public Response findWebhooks(@Context UriInfo uriInfo, @QueryParam(value="event") List<String> events, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="100") int limit) {
        return this.webhooksResourceHelper.findWebhooks(uriInfo, WebhookScope.GLOBAL, events, statistics, start, limit);
    }

    @Operation(summary="Get latest invocations", description="Get the latest invocations for a specific webhook. The authenticated user must be an administrator to call this resource.")
    @Parameters(value={@Parameter(name="webhookId", description="id of the webhook", in=ParameterIn.PATH), @Parameter(name="event", description="the string id of a specific event to retrieve the last invocation for.", in=ParameterIn.QUERY), @Parameter(name="outcomes", description="the outcome to filter for. Can be SUCCESS, FAILURE, ERROR. None specified means that the all will be considered.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a webhook invocation dataset.", responseCode=200, representation=DetailedInvocation.class), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to get webhook.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if the webhook does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}/latest")
    @ScopesAllowed(requiredScope={"ADMIN", "READ_ALL"})
    public Response getLatestInvocation(@PathParam(value="webhookId") int webhookId, @QueryParam(value="event") String eventId, @QueryParam(value="outcome") Set<String> outcomes) {
        return this.webhooksResourceHelper.getLatestInvocation(WebhookScope.GLOBAL, webhookId, eventId, outcomes);
    }

    @Operation(summary="Get statistic", description="Get the statistics for a specific webhook. The authenticated user must be an administrator to call this resource.")
    @Parameters(value={@Parameter(name="webhookId", description="id of the webhook", in=ParameterIn.PATH), @Parameter(name="event", description="the string id of a specific event to retrieve the last invocation for.", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(documentation="returns a webhook invocation dataset.", responseCode=200, representation=RestInvocationHistory.class), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to get webhook.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if the webhook does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}/statistics")
    public Response getStatistics(@PathParam(value="webhookId") int webhookId, @QueryParam(value="event") String eventId) {
        return this.webhooksResourceHelper.getStatistics(WebhookScope.GLOBAL, webhookId, eventId);
    }

    @Operation(summary="Get statistics summary", description="Get the statistics summary for a specific webhook. The authenticated user must be an administrator to call this resource.")
    @Parameter(name="webhookId", description="id of the webhook", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="returns a webhook invocation dataset.", responseCode=200, representation=RestInvocationHistory.class), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to get webhook.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if the webhook does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}/statistics/summary")
    public Response getStatisticsSummary(@PathParam(value="webhookId") int webhookId) {
        return this.webhooksResourceHelper.getStatisticsSummary(WebhookScope.GLOBAL, webhookId);
    }

    @Operation(summary="Get webhook", description="Get a webhook by id. The authenticated user must be an administrator to call this resource.")
    @Parameter(name="webhookId", description="id of the webhook", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="returns a webhook.", responseCode=200, representation=RestWebhook.class), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to get webhook.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if the webhook does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{webhookId}")
    @ScopesAllowed(requiredScope={"ADMIN", "READ_ALL"})
    public Response getWebhook(@PathParam(value="webhookId") int webhookId, @QueryParam(value="statistics") @DefaultValue(value="false") boolean statistics) {
        return this.webhooksResourceHelper.getWebhook(WebhookScope.GLOBAL, webhookId, statistics);
    }

    @Operation(summary="Test webhook", description="Test connectivity to a specific endpoint. The authenticated user must be an administrator to call this resource.")
    @Parameter(name="url", description="the url in which to connect to", in=ParameterIn.QUERY, required=true)
    @ResponseDocs(value={@ResponseDoc(documentation="returns a webhook.", responseCode=200), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to test a connection.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if repository does not exist.", responseCode=404, restError=true)})
    @POST
    @Path(value="/test")
    public Response testWebhook(@QueryParam(value="url") String url) throws ContentTooLongException {
        this.permissionEnforcer.enforceAdmin();
        this.validateUrl(url);
        return this.webhooksResourceHelper.testWebhook(WebhookScope.GLOBAL, url);
    }

    @Operation(summary=" Update webhook", description=" Update an existing webhook. The authenticated user must be an administrator to call this resource.")
    @RequestBody(description="the representation of the updated values for the webhook", required=true, content={@Content(schema=@Schema(implementation=RestWebhook.class))})
    @Parameter(name="webhookId", description="the existing webhook id", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="returns a webhook.", responseCode=200, representation=RestWebhook.class), @ResponseDoc(documentation="returned if the currently authenticated user has insufficient permissions to update a webhook.", responseCode=401, restError=true), @ResponseDoc(documentation="returned if the webhook does not exist.", responseCode=404, restError=true)})
    @PUT
    @Path(value="/{webhookId}")
    @ScopesAllowed(requiredScope={"ADMIN", "MANAGE_SUBSCRIPTIONS"})
    public Response updateWebhook(@PathParam(value="webhookId") int webhookId, RestWebhook webhook) throws ContentTooLongException {
        this.validateUrl(webhook.getUrl());
        return this.webhooksResourceHelper.update(WebhookScope.GLOBAL, webhookId, webhook);
    }

    private void validateUrl(String webhookUrl) throws ContentTooLongException {
        URI uri;
        if (webhookUrl.length() > 2000) {
            throw new ContentTooLongException(this.i18nResolver.getText("confluence.webhooks.restapi.url.length.error"));
        }
        try {
            uri = new URI(webhookUrl);
        }
        catch (Exception ex) {
            throw new BadRequestException(this.i18nResolver.getText("confluence.webhooks.restapi.url.format.error"));
        }
        if (!ALLOWED_SCHEMES.contains(uri.getScheme())) {
            throw new BadRequestException(this.i18nResolver.getText("confluence.webhooks.restapi.url.scheme.error"));
        }
        if (!WEBHOOKS_ALLOW_ALL_HOSTS) {
            try {
                String host = uri.getHost();
                InetAddress inetAddress = Inet6Address.getByName(host);
                String hostAddress = inetAddress.getHostAddress();
                for (String blockedHostRegex : BLOCKED_HOSTS_REGEX) {
                    if (!hostAddress.matches(blockedHostRegex)) continue;
                    throw new BadRequestException(this.i18nResolver.getText("confluence.webhooks.restapi.url.host.error"));
                }
            }
            catch (UnknownHostException e) {
                throw new BadRequestException(this.i18nResolver.getText("confluence.webhooks.restapi.url.format.error"));
            }
        }
    }

    private void enforceReadAllScopeOrAdmin() {
        if (!this.scopesRequestCache.isScopePermitted("READ_ALL")) {
            this.permissionEnforcer.enforceAdmin();
        }
    }
}

