/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.service.people.GroupService;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.plugins.restapi.annotations.LimitRequestSize;
import com.atlassian.confluence.rest.v2.api.annotation.LogRequestInfo;
import com.atlassian.confluence.rest.v2.api.annotation.RateLimited;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.confluence.rest.v2.api.model.ExpansionsParser;
import com.atlassian.confluence.rest.v2.api.model.RestList;
import com.atlassian.confluence.rest.v2.api.model.RestPageRequest;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;

@ExperimentalApi
@AnonymousSiteAccess
@LimitRequestSize(value=0x500000L)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@SendsAnalytics
@Path(value="/group")
@Tag(name="Group")
@LogRequestInfo(headerNames={"X-B3-Traceid", "X-B3-Spanid"}, methods={"GET"})
public class GroupResource {
    private final GroupService groupService;
    private final PersonService personService;

    @Inject
    public GroupResource(@ComponentImport GroupService groupService, @ComponentImport PersonService personService) {
        this.groupService = groupService;
        this.personService = personService;
    }

    @Operation(description="Get a paginated collection of user groups", summary="Get groups")
    @Parameters(value={@Parameter(name="start", description="the start point of the collection to return"), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage")})
    @ResponseDocs(value={@ResponseDoc(documentation="The number of user groups in the system", responseCode=200, representation=Group.class, paged=true), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @RateLimited(propertyName="confluence.full.sync.rl.groups.rps", permitsPerSecond=8.0, type=RateLimited.Type.TWO_LO)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Group> getGroups(@QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        RestPageRequest pageRequest = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return RestList.newRestList((PageResponse)this.groupService.find(expansions).fetchMany((PageRequest)pageRequest)).pageRequest((PageRequest)pageRequest).build();
    }

    @Operation(description="Get the user group with the group name", summary="Get group by name")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to return"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage")})
    @ResponseDocs(value={@ResponseDoc(documentation="The user group with the group name", responseCode=200, representation=Group.class), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @Path(value="{groupName}")
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Group getGroup(@PathParam(value="groupName") String groupName, @QueryParam(value="expand") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return (Group)this.groupService.find(expansions).withName(groupName).fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No group with name : " + groupName)));
    }

    @Operation(description="Get the user group with the group name", summary="Get group by name")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to return"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage")})
    @ResponseDocs(value={@ResponseDoc(documentation="The user group with the group name", responseCode=200, representation=Group.class), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @Path(value="info")
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public Group getGroupByGroupName(@QueryParam(value="groupName") String groupName, @QueryParam(value="expand") String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        return (Group)this.groupService.find(expansions).withName(groupName).fetch().orElseThrow(ServiceExceptionSupplier.notFound((String)("No group with name : " + groupName)));
    }

    @Operation(description="**You need admin permissions to use this endpoint.**  \nGet a paginated collection of users in the given group.", summary="Get members of group")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to lookup the members for"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage"), @Parameter(name="start", description="the start point of the collection to return"), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits")})
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of users in the given group", responseCode=200, representation=Person.class, paged=true), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @Path(value="{groupName}/member")
    @RateLimited(propertyName="confluence.full.sync.rl.group.members.users.rps", permitsPerSecond=2.0, type=RateLimited.Type.TWO_LO)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Person> getMembers(@PathParam(value="groupName") Group group, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return this.getMembersByGroup(group, request, expand);
    }

    @Operation(description="**You need admin permissions to use this endpoint.**  \nGet a paginated collection of users in the given group.", summary="Get members of group")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to lookup the members for"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage"), @Parameter(name="start", description="the start point of the collection to return"), @Parameter(name="limit", description="the limit of the number of items to return, this may be restricted by fixed system limits")})
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of users in the given group", responseCode=200, representation=Person.class, paged=true), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @Path(value="member")
    @AdminOnly
    @RateLimited(propertyName="confluence.full.sync.rl.group.members.users.rps", permitsPerSecond=2.0, type=RateLimited.Type.TWO_LO)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Person> getMembersByGroupName(@QueryParam(value="groupName") String groupName, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Group group = new Group(groupName);
        return this.getMembersByGroup(group, request, expand);
    }

    private PageResponse<Person> getMembersByGroup(Group group, RestPageRequest request, String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        PageResponse results = this.personService.find(expansions).withMembershipOf(group).fetchMany((PageRequest)request);
        return RestList.newRestList((PageResponse)results).pageRequest((PageRequest)request).build();
    }

    @Operation(description="Get a collection of child groups of the given group", summary="Get group members of group")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to look up the members for"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage")})
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of groups in the given group", responseCode=200, representation=Group.class, paged=true), @ResponseDoc(documentation="Client must have Browse All Group Members Permission to access this resource", responseCode=403, restError=true)})
    @GET
    @Path(value="{groupName}/groupmember")
    @RateLimited(propertyName="confluence.full.sync.rl.group.members.groups.rps", permitsPerSecond=2.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Group> getNestedGroupMembers(@PathParam(value="groupName") Group group, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return this.getNestedGroupMembersByGroup(group, request, expand);
    }

    @Operation(description="Get a collection of child groups of the given group", summary="Get group members of group")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to look up the members for"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage")})
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of groups in the given group", responseCode=200, representation=Group.class, paged=true), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @Path(value="groupmember")
    @AdminOnly
    @RateLimited(propertyName="confluence.full.sync.rl.group.members.groups.rps", permitsPerSecond=2.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Group> getNestedGroupMembersByGroupName(@QueryParam(value="groupName") String groupName, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Group group = new Group(groupName);
        return this.getNestedGroupMembersByGroup(group, request, expand);
    }

    private PageResponse<Group> getNestedGroupMembersByGroup(Group group, RestPageRequest request, String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        PageResponse results = this.groupService.find(expansions).withMembershipOf(group).fetchMany((PageRequest)request);
        return RestList.newRestList((PageResponse)results).pageRequest((PageRequest)request).build();
    }

    @Operation(description="Get a collection of the given group's immediate parent groups", summary="Get group parents of a group")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to look up the parents for"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage")})
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of parent groups of the given group", responseCode=200, representation=Group.class, paged=true), @ResponseDoc(documentation="Client must have Browse All Group Members Permission to access this resource", responseCode=403, restError=true)})
    @GET
    @Path(value="{groupName}/groupparent")
    @AdminOnly
    @RateLimited(propertyName="confluence.full.sync.rl.group.parents.rps", permitsPerSecond=10.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Group> getParentGroups(@PathParam(value="groupName") Group group, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return this.getParentGroupsByGroup(group, request, expand);
    }

    @Operation(description="Get a collection of the given group's immediate parent groups", summary="Get group parents of a group")
    @Parameters(value={@Parameter(name="groupName", description="the name of the group to look up the parents for"), @Parameter(name="expand", description="the properties to expand on search result e.g. content.space,space.homepage")})
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of parent groups of the given group", responseCode=200, representation=Group.class, paged=true), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @Path(value="groupparent")
    @AdminOnly
    @RateLimited(propertyName="confluence.full.sync.rl.group.parents.rps", permitsPerSecond=10.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Group> getParentGroupsByGroupName(@QueryParam(value="groupName") String groupName, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Group group = new Group(groupName);
        return this.getParentGroupsByGroup(group, request, expand);
    }

    private PageResponse<Group> getParentGroupsByGroup(Group group, RestPageRequest request, String expand) {
        Expansion[] expansions = ExpansionsParser.parse((String)expand);
        PageResponse results = this.groupService.find(expansions).withParentOf(group).fetchMany((PageRequest)request);
        return RestList.newRestList((PageResponse)results).pageRequest((PageRequest)request).build();
    }

    @Operation(description="Get a collection of the specified group's direct parent groups and all its ancestors (i.e. the parents of its parents, and so on)", summary="Get group ancestor of a group")
    @Parameter(name="groupName", description="the name of the group to look up the ancestor for")
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of parent groups of the given group", responseCode=200, representation=Group.class, paged=true), @ResponseDoc(documentation="Client must have Browse All Group Members Permission to access this resource", responseCode=403, restError=true)})
    @GET
    @Path(value="{groupName}/groupancestor")
    @AdminOnly
    @RateLimited(propertyName="confluence.full.sync.rl.group.ancestors.rps", permitsPerSecond=10.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Group> getAncestorGroups(@PathParam(value="groupName") Group group, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        return this.getAncestorGroupsByGroup(group, request);
    }

    @Operation(description="Get a collection of the specified group's direct parent groups and all its ancestors (i.e. the parents of its parents, and so on)", summary="Get group ancestor of a group")
    @Parameter(name="groupName", description="the name of the group to look up the ancestor for")
    @ResponseDocs(value={@ResponseDoc(documentation="a collection of parent groups of the given group", responseCode=200, representation=Group.class, paged=true), @ResponseDoc(documentation="The calling user does not have permission to view groups", responseCode=403, restError=true)})
    @GET
    @Path(value="groupancestor")
    @AdminOnly
    @RateLimited(propertyName="confluence.full.sync.rl.group.ancestors.rps", permitsPerSecond=10.0)
    @ScopesAllowed(requiredScope={"READ_ALL"})
    public PageResponse<Group> getAncestorGroupsByGroupName(@QueryParam(value="groupName") String groupName, @QueryParam(value="start") int start, @QueryParam(value="limit") @DefaultValue(value="200") int limit, @Context UriInfo uriInfo) {
        RestPageRequest request = new RestPageRequest(uriInfo.getRequestUri(), start, limit);
        Group group = new Group(groupName);
        return this.getAncestorGroupsByGroup(group, request);
    }

    private PageResponse<Group> getAncestorGroupsByGroup(Group group, RestPageRequest request) {
        Expansion[] expansions = ExpansionsParser.parse((String)"");
        PageResponse results = this.groupService.find(expansions).withAncestorOf(group).fetchMany((PageRequest)request);
        return RestList.newRestList((PageResponse)results).pageRequest((PageRequest)request).build();
    }
}

