/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.api.service.index.IndexService;
import com.atlassian.confluence.api.service.index.ReIndexOption;
import com.atlassian.confluence.api.service.index.ReIndexTaskInfo;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/index")
@Produces(value={"application/json;charset=UTF-8"})
@Consumes(value={"application/json"})
@SystemAdminOnly
@SendsAnalytics
@Tag(name="Index Management")
public class IndexResource {
    private static final Logger log = LoggerFactory.getLogger(IndexResource.class);
    private final IndexService indexService;

    @Inject
    public IndexResource(IndexService indexService) {
        this.indexService = indexService;
    }

    @Operation(summary="Rebuild Confluence search index", description="Rebuilds Confluence's search index.\nThis operation is only available to system administrators and may take significant time to complete.\n\nExample request URI(s):\n- `http://example.com/confluence/rest/api/index/reindex`\n- `http://example.com/confluence/rest/api/index/reindex?option=CONTENT_ONLY&spaceKey=DEMO`\n- `http://example.com/confluence/rest/api/index/reindex?option=ATTACHMENT_ONLY&option=CONTENT_ONLY&spaceKey=DEMO&spaceKey=TEST`\n")
    @Parameters(value={@Parameter(name="option", description="The reindex options to control what content types are indexed.\nAvailable options:\n- CONTENT_ONLY: Index only content (pages, blog posts, etc.)\n- ATTACHMENT_ONLY: Index only file attachments\n- USER_ONLY: Index only user information (Only relevant for whole site reindexing, not for specific spaces)\n\nIf no options are specified, a full reindex of all relevant content types will be performed.\nMultiple options can be specified to index specific combinations of content types.\n", in=ParameterIn.QUERY), @Parameter(name="spaceKey", description="Optional space keys to limit the reindex to specific spaces.\nIf specified, only content within these spaces will be reindexed.\nIf no space key's are specified, the entire site will be reindexed.\nMultiple space keys can be provided to reindex multiple spaces.\nIf a space key does not match any existing space, it will be silently ignored.\n", in=ParameterIn.QUERY)})
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="Message indicating that the reindex task was successfully queued.", representation=Map.class), @ResponseDoc(responseCode=400, documentation="Returned if the request parameters are invalid.", restError=true), @ResponseDoc(responseCode=409, documentation="Returned if a reindex operation is already in progress.", restError=true), @ResponseDoc(responseCode=503, documentation="Returned if the reindexing was interrupted", restError=true)})
    @Path(value="/reindex")
    @POST
    @AdminOnly
    @ReadOnlyAccessAllowed
    @PublicApi
    public Response reindex(@QueryParam(value="option") List<ReIndexOption> options, @QueryParam(value="spaceKey") List<String> spaceKeys) {
        if (this.indexService.isReIndexing()) {
            log.warn("Confluence is re-indexing");
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Confluence is re-indexing").build();
        }
        try {
            EnumSet<ReIndexOption> optionSet;
            EnumSet<ReIndexOption> enumSet = optionSet = options == null || options.isEmpty() ? EnumSet.allOf(ReIndexOption.class) : EnumSet.copyOf(options);
            if (this.indexService.reindex(spaceKeys, optionSet)) {
                return Response.ok(Map.of("message", "Reindex was queued successfully, it may take some time to start. To check the status of the reindex job, please use the GET /reindex endpoint once the reindex has started.")).build();
            }
        }
        catch (InterruptedException e) {
            log.error("Reindexing was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"Reindexing was interrupted").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Operation(summary="Reset reindex job status", description="Resets the status of the current in-progress reindex job.\nThis is useful when a reindex job has failed/stalled and needs to be cleared before starting a new reindex operation.\nThis operation is only available to system administrators.\n")
    @ResponseDoc(responseCode=200, documentation="The reindex job status was successfully reset.")
    @Path(value="/resetjob")
    @PUT
    @AdminOnly
    @ReadOnlyAccessAllowed
    @PublicApi
    public Response resetJob() {
        this.indexService.resetJobStatus();
        return Response.ok().build();
    }

    @Operation(summary="Get reindex status", description="Returns the current status of the most recent reindex operation.\nThis includes information about progress, completion status, elapsed time, and job ID.\n\nExample request URI:\n`http://example.com/confluence/rest/api/index/reindex`\n")
    @ResponseDoc(responseCode=200, documentation="Returns the current reindex status information if available, or a status message if no reindex information is available.", representation=ReIndexTaskEntity.class)
    @Path(value="/reindex")
    @GET
    @ScopesAllowed(requiredScope={"READ"})
    @PublicApi
    public Response reIndexStatus() {
        ReIndexTaskInfo indexingTask = this.indexService.getLastReindexingTask();
        if (indexingTask != null) {
            return Response.ok((Object)ReIndexTaskEntity.from(indexingTask)).build();
        }
        return Response.ok(Map.of("message", "Reindex status not available.")).build();
    }

    @Operation(summary="Remove all content from search index", description="Removes all content from the search index, effectively clearing the entire search index.\nThis operation is destructive and will require a full reindex to restore search functionality.\nThis operation is only available to system administrators.\n\n**Warning**: This operation will remove all searchable content from the index.\nUsers will not be able to search for content until a reindex is performed.\n\nExample request URI:\n`http://example.com/confluence/rest/api/index/unindex`\n")
    @ResponseDoc(responseCode=200, documentation="The search index was successfully cleared of all content.")
    @Path(value="/unindex")
    @POST
    @AdminOnly
    @PublicApi
    public Response unIndexAll() {
        this.indexService.unIndexAll();
        return Response.ok().build();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class ReIndexTaskEntity {
        @Schema(description="Whether the reindex operation has finished", example="true")
        private boolean finished = false;
        @Schema(description="Percentage of the reindex operation that has been completed", example="100")
        private int percentageComplete = 0;
        @Schema(description="Elapsed time for the reindex operation", example="00:00:19")
        private String elapsedTime = "0";
        @Schema(description="Unique identifier for the reindex job", example="2154")
        private int jobID;

        ReIndexTaskEntity() {
        }

        static ReIndexTaskEntity from(ReIndexTaskInfo reIndexTask) {
            ReIndexTaskEntity entity = new ReIndexTaskEntity();
            entity.finished = reIndexTask.isFinishedReindexing();
            entity.percentageComplete = reIndexTask.getPercentComplete();
            entity.elapsedTime = reIndexTask.getCompactElapsedTime();
            entity.jobID = reIndexTask.getJobID();
            return entity;
        }

        @VisibleForTesting
        public int getJobID() {
            return this.jobID;
        }

        @VisibleForTesting
        public boolean isFinished() {
            return this.finished;
        }

        @VisibleForTesting
        public int getPercentageComplete() {
            return this.percentageComplete;
        }

        @VisibleForTesting
        public String getElapsedTime() {
            return this.elapsedTime;
        }
    }
}

