/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.restapi.resources;

import com.atlassian.confluence.api.model.InstanceMetrics;
import com.atlassian.confluence.api.service.instance.InstanceMetricsService;
import com.atlassian.confluence.rest.v2.api.annotation.SendsAnalytics;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="/instance-metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
@SystemAdminOnly
@SendsAnalytics
@Tag(name="Instance Metrics")
public final class InstanceMetricsResource {
    private final InstanceMetricsService instanceMetricsService;

    @Inject
    public InstanceMetricsResource(@ComponentImport InstanceMetricsService instanceMetricsService) {
        this.instanceMetricsService = instanceMetricsService;
    }

    @Operation(summary="Get instance metrics", description="Returns simple metrics about this instance.")
    @ResponseDocs(value={@ResponseDoc(responseCode=200, documentation="The instance metrics.", representation=InstanceMetrics.class), @ResponseDoc(responseCode=401, documentation="Returned if the calling User is not authenticated.", restError=true), @ResponseDoc(responseCode=403, documentation="Returned if the calling User does not have necessary permission.", restError=true)})
    @GET
    public Response index() {
        InstanceMetrics instanceMetrics = this.instanceMetricsService.getInstanceMetrics();
        return Response.ok((Object)instanceMetrics).build();
    }
}

